<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for refundItems StructType
 * Meta informations extracted from the WSDL
 * - documentation: Refund zero or more items with a different quantity than originally ordered. Optionally, refund an additional amount. In all cases, the total of the refund request cannot exceed the original order including any already processed
 * refunds.
 * @subpackage Structs
 */
class RefundItems extends AbstractStructBase
{
    /**
     * The additionalRefund
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\AdditionalRefund
     */
    public $additionalRefund;
    /**
     * The itemLine
     * Meta informations extracted from the WSDL
     * - documentation: Item lines can only be used, when the original order contains the different item lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\ItemLine[]
     */
    public $itemLine;
    /**
     * Constructor method for refundItems
     * @uses RefundItems::setAdditionalRefund()
     * @uses RefundItems::setItemLine()
     * @param \Models\Docdata\StructType\AdditionalRefund $additionalRefund
     * @param \Models\Docdata\StructType\ItemLine[] $itemLine
     */
    public function __construct(\Models\Docdata\StructType\AdditionalRefund $additionalRefund = null, array $itemLine = array())
    {
        $this
            ->setAdditionalRefund($additionalRefund)
            ->setItemLine($itemLine);
    }
    /**
     * Get additionalRefund value
     * @return \Models\Docdata\StructType\AdditionalRefund|null
     */
    public function getAdditionalRefund()
    {
        return $this->additionalRefund;
    }
    /**
     * Set additionalRefund value
     * @param \Models\Docdata\StructType\AdditionalRefund $additionalRefund
     * @return \Models\Docdata\StructType\RefundItems
     */
    public function setAdditionalRefund(\Models\Docdata\StructType\AdditionalRefund $additionalRefund = null)
    {
        $this->additionalRefund = $additionalRefund;
        return $this;
    }
    /**
     * Get itemLine value
     * @return \Models\Docdata\StructType\ItemLine[]|null
     */
    public function getItemLine()
    {
        return $this->itemLine;
    }
    /**
     * Set itemLine value
     * @throws \InvalidArgumentException
     * @param \Models\Docdata\StructType\ItemLine[] $itemLine
     * @return \Models\Docdata\StructType\RefundItems
     */
    public function setItemLine(array $itemLine = array())
    {
        foreach ($itemLine as $refundItemsItemLineItem) {
            // validation for constraint: itemType
            if (!$refundItemsItemLineItem instanceof \Models\Docdata\StructType\ItemLine) {
                throw new \InvalidArgumentException(sprintf('The itemLine property can only contain items of \Models\Docdata\StructType\ItemLine, "%s" given', is_object($refundItemsItemLineItem) ? get_class($refundItemsItemLineItem) : gettype($refundItemsItemLineItem)), __LINE__);
            }
        }
        $this->itemLine = $itemLine;
        return $this;
    }
    /**
     * Add item to itemLine value
     * @throws \InvalidArgumentException
     * @param \Models\Docdata\StructType\ItemLine $item
     * @return \Models\Docdata\StructType\RefundItems
     */
    public function addToItemLine(\Models\Docdata\StructType\ItemLine $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Models\Docdata\StructType\ItemLine) {
            throw new \InvalidArgumentException(sprintf('The itemLine property can only contain items of \Models\Docdata\StructType\ItemLine, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->itemLine[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\RefundItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
