<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pointOfSalePaymentInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Point Of Sale payment information.
 * @subpackage Structs
 */
class PointOfSalePaymentInfo extends AbstractStructBase
{
    /**
     * The receipt
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\PointOfSalePaymentReceipt[]
     */
    public $receipt;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for pointOfSalePaymentInfo
     * @uses PointOfSalePaymentInfo::setReceipt()
     * @uses PointOfSalePaymentInfo::setAny()
     * @param \Models\Docdata\StructType\PointOfSalePaymentReceipt[] $receipt
     * @param \DOMDocument $any
     */
    public function __construct(array $receipt = array(), \DOMDocument $any = null)
    {
        $this
            ->setReceipt($receipt)
            ->setAny($any);
    }
    /**
     * Get receipt value
     * @return \Models\Docdata\StructType\PointOfSalePaymentReceipt[]|null
     */
    public function getReceipt()
    {
        return $this->receipt;
    }
    /**
     * Set receipt value
     * @throws \InvalidArgumentException
     * @param \Models\Docdata\StructType\PointOfSalePaymentReceipt[] $receipt
     * @return \Models\Docdata\StructType\PointOfSalePaymentInfo
     */
    public function setReceipt(array $receipt = array())
    {
        foreach ($receipt as $pointOfSalePaymentInfoReceiptItem) {
            // validation for constraint: itemType
            if (!$pointOfSalePaymentInfoReceiptItem instanceof \Models\Docdata\StructType\PointOfSalePaymentReceipt) {
                throw new \InvalidArgumentException(sprintf('The receipt property can only contain items of \Models\Docdata\StructType\PointOfSalePaymentReceipt, "%s" given', is_object($pointOfSalePaymentInfoReceiptItem) ? get_class($pointOfSalePaymentInfoReceiptItem) : gettype($pointOfSalePaymentInfoReceiptItem)), __LINE__);
            }
        }
        $this->receipt = $receipt;
        return $this;
    }
    /**
     * Add item to receipt value
     * @throws \InvalidArgumentException
     * @param \Models\Docdata\StructType\PointOfSalePaymentReceipt $item
     * @return \Models\Docdata\StructType\PointOfSalePaymentInfo
     */
    public function addToReceipt(\Models\Docdata\StructType\PointOfSalePaymentReceipt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Models\Docdata\StructType\PointOfSalePaymentReceipt) {
            throw new \InvalidArgumentException(sprintf('The receipt property can only contain items of \Models\Docdata\StructType\PointOfSalePaymentReceipt, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->receipt[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\PointOfSalePaymentInfo::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\PointOfSalePaymentInfo
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\PointOfSalePaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
