<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pointOfSalePaymentFormattedReceipt StructType
 * Meta informations extracted from the WSDL
 * - documentation: Point Of Sale formatted payment receipt lines.
 * @subpackage Structs
 */
class PointOfSalePaymentFormattedReceipt extends AbstractStructBase
{
    /**
     * The line
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - whiteSpace: preserve
     * @var string[]
     */
    public $line;
    /**
     * Constructor method for pointOfSalePaymentFormattedReceipt
     * @uses PointOfSalePaymentFormattedReceipt::setLine()
     * @param string[] $line
     */
    public function __construct(array $line = array())
    {
        $this
            ->setLine($line);
    }
    /**
     * Get line value
     * @return string[]
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @throws \InvalidArgumentException
     * @param string[] $line
     * @return \Models\Docdata\StructType\PointOfSalePaymentFormattedReceipt
     */
    public function setLine(array $line = array())
    {
        foreach ($line as $pointOfSalePaymentFormattedReceiptLineItem) {
            // validation for constraint: itemType
            if (!is_string($pointOfSalePaymentFormattedReceiptLineItem)) {
                throw new \InvalidArgumentException(sprintf('The line property can only contain items of string, "%s" given', is_object($pointOfSalePaymentFormattedReceiptLineItem) ? get_class($pointOfSalePaymentFormattedReceiptLineItem) : gettype($pointOfSalePaymentFormattedReceiptLineItem)), __LINE__);
            }
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Add item to line value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Models\Docdata\StructType\PointOfSalePaymentFormattedReceipt
     */
    public function addToLine($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The line property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->line[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\PointOfSalePaymentFormattedReceipt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
