<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentSuccess StructType
 * Meta informations extracted from the WSDL
 * - documentation: The payment was successfully authorized.
 * @subpackage Structs
 */
class PaymentSuccess extends AbstractStructBase
{
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: The payment ID with check digit as generated by the payment system.
     * @var int
     */
    public $id;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for paymentSuccess
     * @uses PaymentSuccess::setStatus()
     * @uses PaymentSuccess::setId()
     * @uses PaymentSuccess::setAny()
     * @param string $status
     * @param int $id
     * @param \DOMDocument $any
     */
    public function __construct($status = null, $id = null, \DOMDocument $any = null)
    {
        $this
            ->setStatus($status)
            ->setId($id)
            ->setAny($any);
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \Models\Docdata\EnumType\AuthorizationStatus::valueIsValid()
     * @uses \Models\Docdata\EnumType\AuthorizationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \Models\Docdata\StructType\PaymentSuccess
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\Models\Docdata\EnumType\AuthorizationStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \Models\Docdata\EnumType\AuthorizationStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get id value
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \Models\Docdata\StructType\PaymentSuccess
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\PaymentSuccess::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\PaymentSuccess
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\PaymentSuccess
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
