<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentMethod StructType
 * @subpackage Structs
 */
class PaymentMethod extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The name of the payment method, as it is known by the system.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * The mandate
     * Meta informations extracted from the WSDL
     * - documentation: A list of mandates that can be used with this payment method. For example, a direct debit payment could have zero or more mandates associated with it, whereas an off-line will never have a list of mandates.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\MandateSummary[]
     */
    public $mandate;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for paymentMethod
     * @uses PaymentMethod::setName()
     * @uses PaymentMethod::setMandate()
     * @uses PaymentMethod::setAny()
     * @param string $name
     * @param \Models\Docdata\StructType\MandateSummary[] $mandate
     * @param \DOMDocument $any
     */
    public function __construct($name = null, array $mandate = array(), \DOMDocument $any = null)
    {
        $this
            ->setName($name)
            ->setMandate($mandate)
            ->setAny($any);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Models\Docdata\StructType\PaymentMethod
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get mandate value
     * @return \Models\Docdata\StructType\MandateSummary[]|null
     */
    public function getMandate()
    {
        return $this->mandate;
    }
    /**
     * Set mandate value
     * @throws \InvalidArgumentException
     * @param \Models\Docdata\StructType\MandateSummary[] $mandate
     * @return \Models\Docdata\StructType\PaymentMethod
     */
    public function setMandate(array $mandate = array())
    {
        foreach ($mandate as $paymentMethodMandateItem) {
            // validation for constraint: itemType
            if (!$paymentMethodMandateItem instanceof \Models\Docdata\StructType\MandateSummary) {
                throw new \InvalidArgumentException(sprintf('The mandate property can only contain items of \Models\Docdata\StructType\MandateSummary, "%s" given', is_object($paymentMethodMandateItem) ? get_class($paymentMethodMandateItem) : gettype($paymentMethodMandateItem)), __LINE__);
            }
        }
        $this->mandate = $mandate;
        return $this;
    }
    /**
     * Add item to mandate value
     * @throws \InvalidArgumentException
     * @param \Models\Docdata\StructType\MandateSummary $item
     * @return \Models\Docdata\StructType\PaymentMethod
     */
    public function addToMandate(\Models\Docdata\StructType\MandateSummary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Models\Docdata\StructType\MandateSummary) {
            throw new \InvalidArgumentException(sprintf('The mandate property can only contain items of \Models\Docdata\StructType\MandateSummary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->mandate[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\PaymentMethod::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\PaymentMethod
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\PaymentMethod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
