<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for offlinePaymentInput StructType
 * Meta informations extracted from the WSDL
 * - documentation: Offline payment input.
 * @subpackage Structs
 */
class OfflinePaymentInput extends AbstractStructBase
{
    /**
     * The method
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $method;
    /**
     * The register
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\Register
     */
    public $register;
    /**
     * Constructor method for offlinePaymentInput
     * @uses OfflinePaymentInput::setMethod()
     * @uses OfflinePaymentInput::setRegister()
     * @param string $method
     * @param \Models\Docdata\StructType\Register $register
     */
    public function __construct($method = null, \Models\Docdata\StructType\Register $register = null)
    {
        $this
            ->setMethod($method)
            ->setRegister($register);
    }
    /**
     * Get method value
     * @return string
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @param string $method
     * @return \Models\Docdata\StructType\OfflinePaymentInput
     */
    public function setMethod($method = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($method) && strlen($method) > 50) || (is_array($method) && count($method) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($method) ? strlen($method) : count($method)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($method) && strlen($method) < 1) || (is_array($method) && count($method) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($method) && !is_string($method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($method)), __LINE__);
        }
        $this->method = $method;
        return $this;
    }
    /**
     * Get register value
     * @return \Models\Docdata\StructType\Register|null
     */
    public function getRegister()
    {
        return $this->register;
    }
    /**
     * Set register value
     * @param \Models\Docdata\StructType\Register $register
     * @return \Models\Docdata\StructType\OfflinePaymentInput
     */
    public function setRegister(\Models\Docdata\StructType\Register $register = null)
    {
        $this->register = $register;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\OfflinePaymentInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
