<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for listPaymentMethodsResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Response to a listPaymentMethods request.
 * @subpackage Structs
 */
class ListPaymentMethodsResponse extends AbstractStructBase
{
    /**
     * The listPaymentMethodsErrors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\ListPaymentMethodsErrors
     */
    public $listPaymentMethodsErrors;
    /**
     * The listPaymentMethodsSuccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\ListPaymentMethodsSuccess
     */
    public $listPaymentMethodsSuccess;
    /**
     * The ddpXsdVersion
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $ddpXsdVersion;
    /**
     * Constructor method for listPaymentMethodsResponse
     * @uses ListPaymentMethodsResponse::setListPaymentMethodsErrors()
     * @uses ListPaymentMethodsResponse::setListPaymentMethodsSuccess()
     * @uses ListPaymentMethodsResponse::setDdpXsdVersion()
     * @param \Models\Docdata\StructType\ListPaymentMethodsErrors $listPaymentMethodsErrors
     * @param \Models\Docdata\StructType\ListPaymentMethodsSuccess $listPaymentMethodsSuccess
     * @param string $ddpXsdVersion
     */
    public function __construct(\Models\Docdata\StructType\ListPaymentMethodsErrors $listPaymentMethodsErrors = null, \Models\Docdata\StructType\ListPaymentMethodsSuccess $listPaymentMethodsSuccess = null, $ddpXsdVersion = null)
    {
        $this
            ->setListPaymentMethodsErrors($listPaymentMethodsErrors)
            ->setListPaymentMethodsSuccess($listPaymentMethodsSuccess)
            ->setDdpXsdVersion($ddpXsdVersion);
    }
    /**
     * Get listPaymentMethodsErrors value
     * @return \Models\Docdata\StructType\ListPaymentMethodsErrors
     */
    public function getListPaymentMethodsErrors()
    {
        return $this->listPaymentMethodsErrors;
    }
    /**
     * Set listPaymentMethodsErrors value
     * @param \Models\Docdata\StructType\ListPaymentMethodsErrors $listPaymentMethodsErrors
     * @return \Models\Docdata\StructType\ListPaymentMethodsResponse
     */
    public function setListPaymentMethodsErrors(\Models\Docdata\StructType\ListPaymentMethodsErrors $listPaymentMethodsErrors = null)
    {
        $this->listPaymentMethodsErrors = $listPaymentMethodsErrors;
        return $this;
    }
    /**
     * Get listPaymentMethodsSuccess value
     * @return \Models\Docdata\StructType\ListPaymentMethodsSuccess
     */
    public function getListPaymentMethodsSuccess()
    {
        return $this->listPaymentMethodsSuccess;
    }
    /**
     * Set listPaymentMethodsSuccess value
     * @param \Models\Docdata\StructType\ListPaymentMethodsSuccess $listPaymentMethodsSuccess
     * @return \Models\Docdata\StructType\ListPaymentMethodsResponse
     */
    public function setListPaymentMethodsSuccess(\Models\Docdata\StructType\ListPaymentMethodsSuccess $listPaymentMethodsSuccess = null)
    {
        $this->listPaymentMethodsSuccess = $listPaymentMethodsSuccess;
        return $this;
    }
    /**
     * Get ddpXsdVersion value
     * @return string
     */
    public function getDdpXsdVersion()
    {
        return $this->ddpXsdVersion;
    }
    /**
     * Set ddpXsdVersion value
     * @param string $ddpXsdVersion
     * @return \Models\Docdata\StructType\ListPaymentMethodsResponse
     */
    public function setDdpXsdVersion($ddpXsdVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) > 35) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($ddpXsdVersion) ? strlen($ddpXsdVersion) : count($ddpXsdVersion)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) < 1) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ddpXsdVersion) && !is_string($ddpXsdVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ddpXsdVersion)), __LINE__);
        }
        $this->ddpXsdVersion = $ddpXsdVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\ListPaymentMethodsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
