<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for item StructType
 * Meta informations extracted from the WSDL
 * - documentation: A single (line) item for this order.
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The human-readable name of this item.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - documentation: A code or article number identifying this item.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $code;
    /**
     * The quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Quantity
     */
    public $quantity;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: The description of the item.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $description;
    /**
     * The netAmount
     * Meta informations extracted from the WSDL
     * - documentation: The net amount for a single piece of this item.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Amount
     */
    public $netAmount;
    /**
     * The grossAmount
     * Meta informations extracted from the WSDL
     * - documentation: The gross amount for a single piece of this item.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Amount
     */
    public $grossAmount;
    /**
     * The vat
     * Meta informations extracted from the WSDL
     * - documentation: The VAT amount for a single piece of this item.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Vat
     */
    public $vat;
    /**
     * The totalNetAmount
     * Meta informations extracted from the WSDL
     * - documentation: The total net amount for this item.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Amount
     */
    public $totalNetAmount;
    /**
     * The totalGrossAmount
     * Meta informations extracted from the WSDL
     * - documentation: The total gross amount for this item.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Amount
     */
    public $totalGrossAmount;
    /**
     * The totalVat
     * Meta informations extracted from the WSDL
     * - documentation: The total VAT amount for this item.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Vat
     */
    public $totalVat;
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $number;
    /**
     * The image
     * Meta informations extracted from the WSDL
     * - documentation: URL pointing to the location of the order item's image. The image itself can be subject to certain limitations on file size and image dimensions, defined by docdata.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 2048
     * - minLength: 1
     * @var string
     */
    public $image;
    /**
     * Constructor method for item
     * @uses Item::setName()
     * @uses Item::setCode()
     * @uses Item::setQuantity()
     * @uses Item::setDescription()
     * @uses Item::setNetAmount()
     * @uses Item::setGrossAmount()
     * @uses Item::setVat()
     * @uses Item::setTotalNetAmount()
     * @uses Item::setTotalGrossAmount()
     * @uses Item::setTotalVat()
     * @uses Item::setNumber()
     * @uses Item::setImage()
     * @param string $name
     * @param string $code
     * @param \Models\Docdata\StructType\Quantity $quantity
     * @param string $description
     * @param \Models\Docdata\StructType\Amount $netAmount
     * @param \Models\Docdata\StructType\Amount $grossAmount
     * @param \Models\Docdata\StructType\Vat $vat
     * @param \Models\Docdata\StructType\Amount $totalNetAmount
     * @param \Models\Docdata\StructType\Amount $totalGrossAmount
     * @param \Models\Docdata\StructType\Vat $totalVat
     * @param int $number
     * @param string $image
     */
    public function __construct($name = null, $code = null, \Models\Docdata\StructType\Quantity $quantity = null, $description = null, \Models\Docdata\StructType\Amount $netAmount = null, \Models\Docdata\StructType\Amount $grossAmount = null, \Models\Docdata\StructType\Vat $vat = null, \Models\Docdata\StructType\Amount $totalNetAmount = null, \Models\Docdata\StructType\Amount $totalGrossAmount = null, \Models\Docdata\StructType\Vat $totalVat = null, $number = null, $image = null)
    {
        $this
            ->setName($name)
            ->setCode($code)
            ->setQuantity($quantity)
            ->setDescription($description)
            ->setNetAmount($netAmount)
            ->setGrossAmount($grossAmount)
            ->setVat($vat)
            ->setTotalNetAmount($totalNetAmount)
            ->setTotalGrossAmount($totalGrossAmount)
            ->setTotalVat($totalVat)
            ->setNumber($number)
            ->setImage($image);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Models\Docdata\StructType\Item
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get code value
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \Models\Docdata\StructType\Item
     */
    public function setCode($code = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($code) && strlen($code) > 50) || (is_array($code) && count($code) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($code) ? strlen($code) : count($code)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($code) && strlen($code) < 1) || (is_array($code) && count($code) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get quantity value
     * @return \Models\Docdata\StructType\Quantity
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param \Models\Docdata\StructType\Quantity $quantity
     * @return \Models\Docdata\StructType\Item
     */
    public function setQuantity(\Models\Docdata\StructType\Quantity $quantity = null)
    {
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Models\Docdata\StructType\Item
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 100) || (is_array($description) && count($description) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($description) && strlen($description) < 1) || (is_array($description) && count($description) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get netAmount value
     * @return \Models\Docdata\StructType\Amount
     */
    public function getNetAmount()
    {
        return $this->netAmount;
    }
    /**
     * Set netAmount value
     * @param \Models\Docdata\StructType\Amount $netAmount
     * @return \Models\Docdata\StructType\Item
     */
    public function setNetAmount(\Models\Docdata\StructType\Amount $netAmount = null)
    {
        $this->netAmount = $netAmount;
        return $this;
    }
    /**
     * Get grossAmount value
     * @return \Models\Docdata\StructType\Amount
     */
    public function getGrossAmount()
    {
        return $this->grossAmount;
    }
    /**
     * Set grossAmount value
     * @param \Models\Docdata\StructType\Amount $grossAmount
     * @return \Models\Docdata\StructType\Item
     */
    public function setGrossAmount(\Models\Docdata\StructType\Amount $grossAmount = null)
    {
        $this->grossAmount = $grossAmount;
        return $this;
    }
    /**
     * Get vat value
     * @return \Models\Docdata\StructType\Vat
     */
    public function getVat()
    {
        return $this->vat;
    }
    /**
     * Set vat value
     * @param \Models\Docdata\StructType\Vat $vat
     * @return \Models\Docdata\StructType\Item
     */
    public function setVat(\Models\Docdata\StructType\Vat $vat = null)
    {
        $this->vat = $vat;
        return $this;
    }
    /**
     * Get totalNetAmount value
     * @return \Models\Docdata\StructType\Amount
     */
    public function getTotalNetAmount()
    {
        return $this->totalNetAmount;
    }
    /**
     * Set totalNetAmount value
     * @param \Models\Docdata\StructType\Amount $totalNetAmount
     * @return \Models\Docdata\StructType\Item
     */
    public function setTotalNetAmount(\Models\Docdata\StructType\Amount $totalNetAmount = null)
    {
        $this->totalNetAmount = $totalNetAmount;
        return $this;
    }
    /**
     * Get totalGrossAmount value
     * @return \Models\Docdata\StructType\Amount
     */
    public function getTotalGrossAmount()
    {
        return $this->totalGrossAmount;
    }
    /**
     * Set totalGrossAmount value
     * @param \Models\Docdata\StructType\Amount $totalGrossAmount
     * @return \Models\Docdata\StructType\Item
     */
    public function setTotalGrossAmount(\Models\Docdata\StructType\Amount $totalGrossAmount = null)
    {
        $this->totalGrossAmount = $totalGrossAmount;
        return $this;
    }
    /**
     * Get totalVat value
     * @return \Models\Docdata\StructType\Vat
     */
    public function getTotalVat()
    {
        return $this->totalVat;
    }
    /**
     * Set totalVat value
     * @param \Models\Docdata\StructType\Vat $totalVat
     * @return \Models\Docdata\StructType\Item
     */
    public function setTotalVat(\Models\Docdata\StructType\Vat $totalVat = null)
    {
        $this->totalVat = $totalVat;
        return $this;
    }
    /**
     * Get number value
     * @return int
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \Models\Docdata\StructType\Item
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !is_numeric($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get image value
     * @return string|null
     */
    public function getImage()
    {
        return $this->image;
    }
    /**
     * Set image value
     * @param string $image
     * @return \Models\Docdata\StructType\Item
     */
    public function setImage($image = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($image) && strlen($image) > 2048) || (is_array($image) && count($image) > 2048)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2048 element(s) or a scalar of 2048 character(s) at most, "%d" length given', is_scalar($image) ? strlen($image) : count($image)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($image) && strlen($image) < 1) || (is_array($image) && count($image) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($image)), __LINE__);
        }
        $this->image = $image;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\Item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
