<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for giftCardPaymentInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Gift card payment information.
 * @subpackage Structs
 */
class GiftCardPaymentInfo extends AbstractStructBase
{
    /**
     * The giftCardNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $giftCardNumber;
    /**
     * The balance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $balance;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for giftCardPaymentInfo
     * @uses GiftCardPaymentInfo::setGiftCardNumber()
     * @uses GiftCardPaymentInfo::setBalance()
     * @uses GiftCardPaymentInfo::setAny()
     * @param string $giftCardNumber
     * @param string $balance
     * @param \DOMDocument $any
     */
    public function __construct($giftCardNumber = null, $balance = null, \DOMDocument $any = null)
    {
        $this
            ->setGiftCardNumber($giftCardNumber)
            ->setBalance($balance)
            ->setAny($any);
    }
    /**
     * Get giftCardNumber value
     * @return string
     */
    public function getGiftCardNumber()
    {
        return $this->giftCardNumber;
    }
    /**
     * Set giftCardNumber value
     * @param string $giftCardNumber
     * @return \Models\Docdata\StructType\GiftCardPaymentInfo
     */
    public function setGiftCardNumber($giftCardNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($giftCardNumber) && strlen($giftCardNumber) > 50) || (is_array($giftCardNumber) && count($giftCardNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($giftCardNumber) ? strlen($giftCardNumber) : count($giftCardNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($giftCardNumber) && strlen($giftCardNumber) < 1) || (is_array($giftCardNumber) && count($giftCardNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($giftCardNumber) && !is_string($giftCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($giftCardNumber)), __LINE__);
        }
        $this->giftCardNumber = $giftCardNumber;
        return $this;
    }
    /**
     * Get balance value
     * @return string
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param string $balance
     * @return \Models\Docdata\StructType\GiftCardPaymentInfo
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($balance) && strlen($balance) > 50) || (is_array($balance) && count($balance) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($balance) ? strlen($balance) : count($balance)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($balance) && strlen($balance) < 1) || (is_array($balance) && count($balance) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($balance) && !is_string($balance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($balance)), __LINE__);
        }
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\GiftCardPaymentInfo::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\GiftCardPaymentInfo
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\GiftCardPaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
