<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for extendedStatusRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Allows to request the extended status of an order and its payments.
 * @subpackage Structs
 */
class ExtendedStatusRequest extends AbstractStructBase
{
    /**
     * The merchant
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Merchant
     */
    public $merchant;
    /**
     * The paymentOrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 32
     * - minLength: 32
     * - pattern: [A-Z,0-9]{32}
     * @var string
     */
    public $paymentOrderKey;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - fixed: 1.3
     * - use: required
     * @var float
     */
    public $version;
    /**
     * The integrationInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\TechnicalIntegrationInfo
     */
    public $integrationInfo;
    /**
     * The testExtensibility
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Test extensibility of client implementation by returning test elements and attributes indicated by with the names and string value "_any".
     * - use: optional
     * @var bool
     */
    public $testExtensibility;
    /**
     * Constructor method for extendedStatusRequest
     * @uses ExtendedStatusRequest::setMerchant()
     * @uses ExtendedStatusRequest::setPaymentOrderKey()
     * @uses ExtendedStatusRequest::setVersion()
     * @uses ExtendedStatusRequest::setIntegrationInfo()
     * @uses ExtendedStatusRequest::setTestExtensibility()
     * @param \Models\Docdata\StructType\Merchant $merchant
     * @param string $paymentOrderKey
     * @param float $version
     * @param \Models\Docdata\StructType\TechnicalIntegrationInfo $integrationInfo
     * @param bool $testExtensibility
     */
    public function __construct(\Models\Docdata\StructType\Merchant $merchant = null, $paymentOrderKey = null, $version = null, \Models\Docdata\StructType\TechnicalIntegrationInfo $integrationInfo = null, $testExtensibility = false)
    {
        $this
            ->setMerchant($merchant)
            ->setPaymentOrderKey($paymentOrderKey)
            ->setVersion($version)
            ->setIntegrationInfo($integrationInfo)
            ->setTestExtensibility($testExtensibility);
    }
    /**
     * Get merchant value
     * @return \Models\Docdata\StructType\Merchant
     */
    public function getMerchant()
    {
        return $this->merchant;
    }
    /**
     * Set merchant value
     * @param \Models\Docdata\StructType\Merchant $merchant
     * @return \Models\Docdata\StructType\ExtendedStatusRequest
     */
    public function setMerchant(\Models\Docdata\StructType\Merchant $merchant = null)
    {
        $this->merchant = $merchant;
        return $this;
    }
    /**
     * Get paymentOrderKey value
     * @return string
     */
    public function getPaymentOrderKey()
    {
        return $this->paymentOrderKey;
    }
    /**
     * Set paymentOrderKey value
     * @param string $paymentOrderKey
     * @return \Models\Docdata\StructType\ExtendedStatusRequest
     */
    public function setPaymentOrderKey($paymentOrderKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($paymentOrderKey) && strlen($paymentOrderKey) > 32) || (is_array($paymentOrderKey) && count($paymentOrderKey) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($paymentOrderKey) ? strlen($paymentOrderKey) : count($paymentOrderKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($paymentOrderKey) && strlen($paymentOrderKey) < 32) || (is_array($paymentOrderKey) && count($paymentOrderKey) < 32)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($paymentOrderKey) && !preg_match('/[A-Z,0-9]{32}/', $paymentOrderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z,0-9]{32}", "%s" given', var_export($paymentOrderKey, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($paymentOrderKey) && !is_string($paymentOrderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentOrderKey)), __LINE__);
        }
        $this->paymentOrderKey = $paymentOrderKey;
        return $this;
    }
    /**
     * Get version value
     * @return float
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param float $version
     * @return \Models\Docdata\StructType\ExtendedStatusRequest
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Get integrationInfo value
     * @return \Models\Docdata\StructType\TechnicalIntegrationInfo|null
     */
    public function getIntegrationInfo()
    {
        return $this->integrationInfo;
    }
    /**
     * Set integrationInfo value
     * @param \Models\Docdata\StructType\TechnicalIntegrationInfo $integrationInfo
     * @return \Models\Docdata\StructType\ExtendedStatusRequest
     */
    public function setIntegrationInfo(\Models\Docdata\StructType\TechnicalIntegrationInfo $integrationInfo = null)
    {
        $this->integrationInfo = $integrationInfo;
        return $this;
    }
    /**
     * Get testExtensibility value
     * @return bool|null
     */
    public function getTestExtensibility()
    {
        return $this->testExtensibility;
    }
    /**
     * Set testExtensibility value
     * @param bool $testExtensibility
     * @return \Models\Docdata\StructType\ExtendedStatusRequest
     */
    public function setTestExtensibility($testExtensibility = false)
    {
        $this->testExtensibility = $testExtensibility;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\ExtendedStatusRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
