<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for directDebitPaymentInput StructType
 * Meta informations extracted from the WSDL
 * - documentation: Direct debit payment input.
 * @subpackage Structs
 */
class DirectDebitPaymentInput extends AbstractStructBase
{
    /**
     * The iban
     * Meta informations extracted from the WSDL
     * - maxLength: 34
     * - maxOccurs: 1
     * - minLength: 15
     * - minOccurs: 1
     * - type: ddp:iban
     * @var string
     */
    public $iban;
    /**
     * The mandateNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $mandateNumber;
    /**
     * The holderName
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $holderName;
    /**
     * The bic
     * Meta informations extracted from the WSDL
     * - maxLength: 11
     * - maxOccurs: 1
     * - minLength: 8
     * - minOccurs: 0
     * - type: ddp:bic
     * @var string
     */
    public $bic;
    /**
     * Constructor method for directDebitPaymentInput
     * @uses DirectDebitPaymentInput::setIban()
     * @uses DirectDebitPaymentInput::setMandateNumber()
     * @uses DirectDebitPaymentInput::setHolderName()
     * @uses DirectDebitPaymentInput::setBic()
     * @param string $iban
     * @param string $mandateNumber
     * @param string $holderName
     * @param string $bic
     */
    public function __construct($iban = null, $mandateNumber = null, $holderName = null, $bic = null)
    {
        $this
            ->setIban($iban)
            ->setMandateNumber($mandateNumber)
            ->setHolderName($holderName)
            ->setBic($bic);
    }
    /**
     * Get iban value
     * @return string
     */
    public function getIban()
    {
        return $this->iban;
    }
    /**
     * Set iban value
     * @param string $iban
     * @return \Models\Docdata\StructType\DirectDebitPaymentInput
     */
    public function setIban($iban = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iban) && strlen($iban) > 34) || (is_array($iban) && count($iban) > 34)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 34 element(s) or a scalar of 34 character(s) at most, "%d" length given', is_scalar($iban) ? strlen($iban) : count($iban)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iban) && strlen($iban) < 15) || (is_array($iban) && count($iban) < 15)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iban)), __LINE__);
        }
        $this->iban = $iban;
        return $this;
    }
    /**
     * Get mandateNumber value
     * @return string
     */
    public function getMandateNumber()
    {
        return $this->mandateNumber;
    }
    /**
     * Set mandateNumber value
     * @param string $mandateNumber
     * @return \Models\Docdata\StructType\DirectDebitPaymentInput
     */
    public function setMandateNumber($mandateNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mandateNumber) && strlen($mandateNumber) > 35) || (is_array($mandateNumber) && count($mandateNumber) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($mandateNumber) ? strlen($mandateNumber) : count($mandateNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($mandateNumber) && strlen($mandateNumber) < 1) || (is_array($mandateNumber) && count($mandateNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mandateNumber) && !is_string($mandateNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mandateNumber)), __LINE__);
        }
        $this->mandateNumber = $mandateNumber;
        return $this;
    }
    /**
     * Get holderName value
     * @return string|null
     */
    public function getHolderName()
    {
        return $this->holderName;
    }
    /**
     * Set holderName value
     * @param string $holderName
     * @return \Models\Docdata\StructType\DirectDebitPaymentInput
     */
    public function setHolderName($holderName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($holderName) && strlen($holderName) > 35) || (is_array($holderName) && count($holderName) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($holderName) ? strlen($holderName) : count($holderName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($holderName) && strlen($holderName) < 1) || (is_array($holderName) && count($holderName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($holderName) && !is_string($holderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($holderName)), __LINE__);
        }
        $this->holderName = $holderName;
        return $this;
    }
    /**
     * Get bic value
     * @return string|null
     */
    public function getBic()
    {
        return $this->bic;
    }
    /**
     * Set bic value
     * @param string $bic
     * @return \Models\Docdata\StructType\DirectDebitPaymentInput
     */
    public function setBic($bic = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bic) && strlen($bic) > 11) || (is_array($bic) && count($bic) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($bic) ? strlen($bic) : count($bic)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bic) && strlen($bic) < 8) || (is_array($bic) && count($bic) < 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bic) && !is_string($bic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bic)), __LINE__);
        }
        $this->bic = $bic;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\DirectDebitPaymentInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
