<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for destination StructType
 * @subpackage Structs
 */
class Destination extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Name of the destination.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Name
     */
    public $name;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - documentation: Address of the destination.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Address
     */
    public $address;
    /**
     * Constructor method for destination
     * @uses Destination::setName()
     * @uses Destination::setAddress()
     * @param \Models\Docdata\StructType\Name $name
     * @param \Models\Docdata\StructType\Address $address
     */
    public function __construct(\Models\Docdata\StructType\Name $name = null, \Models\Docdata\StructType\Address $address = null)
    {
        $this
            ->setName($name)
            ->setAddress($address);
    }
    /**
     * Get name value
     * @return \Models\Docdata\StructType\Name
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \Models\Docdata\StructType\Name $name
     * @return \Models\Docdata\StructType\Destination
     */
    public function setName(\Models\Docdata\StructType\Name $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get address value
     * @return \Models\Docdata\StructType\Address
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \Models\Docdata\StructType\Address $address
     * @return \Models\Docdata\StructType\Destination
     */
    public function setAddress(\Models\Docdata\StructType\Address $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\Destination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
