<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cardTokenInput StructType
 * Meta informations extracted from the WSDL
 * - documentation: Generic credit or debit card payment input. This can be either: 1. A security code 2. A base64 encoded string containing the encrypted card details and the key alias
 * @subpackage Structs
 */
class CardTokenInput extends AbstractStructBase
{
    /**
     * The securityCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: 3 or 4 digit security code (cvc2, cid, cvv2).
     * - pattern: [0-9]{3,4}
     * @var string
     */
    public $securityCode;
    /**
     * The encryptedData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $encryptedData;
    /**
     * Constructor method for cardTokenInput
     * @uses CardTokenInput::setSecurityCode()
     * @uses CardTokenInput::setEncryptedData()
     * @param string $securityCode
     * @param string $encryptedData
     */
    public function __construct($securityCode = null, $encryptedData = null)
    {
        $this
            ->setSecurityCode($securityCode)
            ->setEncryptedData($encryptedData);
    }
    /**
     * Get securityCode value
     * @return string
     */
    public function getSecurityCode()
    {
        return $this->securityCode;
    }
    /**
     * Set securityCode value
     * @param string $securityCode
     * @return \Models\Docdata\StructType\CardTokenInput
     */
    public function setSecurityCode($securityCode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($securityCode) && !preg_match('/[0-9]{3,4}/', $securityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{3,4}", "%s" given', var_export($securityCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($securityCode) && !is_string($securityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($securityCode)), __LINE__);
        }
        $this->securityCode = $securityCode;
        return $this;
    }
    /**
     * Get encryptedData value
     * @return string
     */
    public function getEncryptedData()
    {
        return $this->encryptedData;
    }
    /**
     * Set encryptedData value
     * @param string $encryptedData
     * @return \Models\Docdata\StructType\CardTokenInput
     */
    public function setEncryptedData($encryptedData = null)
    {
        // validation for constraint: string
        if (!is_null($encryptedData) && !is_string($encryptedData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($encryptedData)), __LINE__);
        }
        $this->encryptedData = $encryptedData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\CardTokenInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
