<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for captureResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Response to a capture request.
 * @subpackage Structs
 */
class CaptureResponse extends AbstractStructBase
{
    /**
     * The captureErrors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\CaptureErrors
     */
    public $captureErrors;
    /**
     * The captureSuccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\CaptureSuccess
     */
    public $captureSuccess;
    /**
     * The ddpXsdVersion
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $ddpXsdVersion;
    /**
     * Constructor method for captureResponse
     * @uses CaptureResponse::setCaptureErrors()
     * @uses CaptureResponse::setCaptureSuccess()
     * @uses CaptureResponse::setDdpXsdVersion()
     * @param \Models\Docdata\StructType\CaptureErrors $captureErrors
     * @param \Models\Docdata\StructType\CaptureSuccess $captureSuccess
     * @param string $ddpXsdVersion
     */
    public function __construct(\Models\Docdata\StructType\CaptureErrors $captureErrors = null, \Models\Docdata\StructType\CaptureSuccess $captureSuccess = null, $ddpXsdVersion = null)
    {
        $this
            ->setCaptureErrors($captureErrors)
            ->setCaptureSuccess($captureSuccess)
            ->setDdpXsdVersion($ddpXsdVersion);
    }
    /**
     * Get captureErrors value
     * @return \Models\Docdata\StructType\CaptureErrors
     */
    public function getCaptureErrors()
    {
        return $this->captureErrors;
    }
    /**
     * Set captureErrors value
     * @param \Models\Docdata\StructType\CaptureErrors $captureErrors
     * @return \Models\Docdata\StructType\CaptureResponse
     */
    public function setCaptureErrors(\Models\Docdata\StructType\CaptureErrors $captureErrors = null)
    {
        $this->captureErrors = $captureErrors;
        return $this;
    }
    /**
     * Get captureSuccess value
     * @return \Models\Docdata\StructType\CaptureSuccess
     */
    public function getCaptureSuccess()
    {
        return $this->captureSuccess;
    }
    /**
     * Set captureSuccess value
     * @param \Models\Docdata\StructType\CaptureSuccess $captureSuccess
     * @return \Models\Docdata\StructType\CaptureResponse
     */
    public function setCaptureSuccess(\Models\Docdata\StructType\CaptureSuccess $captureSuccess = null)
    {
        $this->captureSuccess = $captureSuccess;
        return $this;
    }
    /**
     * Get ddpXsdVersion value
     * @return string
     */
    public function getDdpXsdVersion()
    {
        return $this->ddpXsdVersion;
    }
    /**
     * Set ddpXsdVersion value
     * @param string $ddpXsdVersion
     * @return \Models\Docdata\StructType\CaptureResponse
     */
    public function setDdpXsdVersion($ddpXsdVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) > 35) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($ddpXsdVersion) ? strlen($ddpXsdVersion) : count($ddpXsdVersion)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) < 1) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ddpXsdVersion) && !is_string($ddpXsdVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ddpXsdVersion)), __LINE__);
        }
        $this->ddpXsdVersion = $ddpXsdVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\CaptureResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
