<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bankTransferPaymentInput StructType
 * Meta informations extracted from the WSDL
 * - documentation: Bank transfer payment input.
 * @subpackage Structs
 */
class BankTransferPaymentInput extends AbstractStructBase
{
    /**
     * The emailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Email address, all characters are allowed except white space, single quote, and double quote.
     * - pattern: [^\s'"]+@[^\s'".@]+(\.[^\s'".@]+)*
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $emailAddress;
    /**
     * Constructor method for bankTransferPaymentInput
     * @uses BankTransferPaymentInput::setEmailAddress()
     * @param string $emailAddress
     */
    public function __construct($emailAddress = null)
    {
        $this
            ->setEmailAddress($emailAddress);
    }
    /**
     * Get emailAddress value
     * @return string
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \Models\Docdata\StructType\BankTransferPaymentInput
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: pattern
        if (is_scalar($emailAddress) && !preg_match('/[^\s'"]+@[^\s'".@]+(\.[^\s'".@]+)*/', $emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^\s\'"]+@[^\s\'".@]+(\.[^\s\'".@]+)*", "%s" given', var_export($emailAddress, true)), __LINE__);
        }
        // validation for constraint: maxLength
        if ((is_scalar($emailAddress) && strlen($emailAddress) > 100) || (is_array($emailAddress) && count($emailAddress) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($emailAddress) ? strlen($emailAddress) : count($emailAddress)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($emailAddress) && strlen($emailAddress) < 1) || (is_array($emailAddress) && count($emailAddress) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\BankTransferPaymentInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
