<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for approximateTotals StructType
 * @subpackage Structs
 */
class ApproximateTotals extends AbstractStructBase
{
    /**
     * The totalRegistered
     * Meta informations extracted from the WSDL
     * - documentation: The initial total amount requested for the order.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $totalRegistered;
    /**
     * The totalShopperPending
     * Meta informations extracted from the WSDL
     * - documentation: The amount for the order that is currently pending with the shopper.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $totalShopperPending;
    /**
     * The totalAcquirerPending
     * Meta informations extracted from the WSDL
     * - documentation: The amount for the order that is currently pending with an acquirer.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $totalAcquirerPending;
    /**
     * The totalAcquirerApproved
     * Meta informations extracted from the WSDL
     * - documentation: The amount for the order that is currently approved by an acquirer.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $totalAcquirerApproved;
    /**
     * The totalCaptured
     * Meta informations extracted from the WSDL
     * - documentation: The currently captured total amount for the order.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $totalCaptured;
    /**
     * The totalRefunded
     * Meta informations extracted from the WSDL
     * - documentation: The currently refunded total amount for the order.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $totalRefunded;
    /**
     * The totalChargedback
     * Meta informations extracted from the WSDL
     * - documentation: The currently chargedback amount for the order.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $totalChargedback;
    /**
     * The totalReversed
     * Meta informations extracted from the WSDL
     * - documentation: The currently reversed amount for the order.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $totalReversed;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The exchangedTo
     * Meta informations extracted from the WSDL
     * - documentation: If multiple currencies are included in the totals, then the approximation, for convenience is based on a conversion. This is the currency that is used to convert to. | ISO 4217:2008
     * - use: optional
     * - pattern: [A-Z][A-Z][A-Z]
     * @var string
     */
    public $exchangedTo;
    /**
     * The exchangeRateDate
     * Meta informations extracted from the WSDL
     * - documentation: If multiple currencies are included in the totals, then the approximation, for convenience is based on a conversion. This is the date on which the conversion was performed for the calculation of the totals. | A date formatted as
     * yyyy-MM-dd HH:mm:ss, for example February 25th, 2014, 3 past twelve and 4 seconds, would become "2012-02-25 12:03:04".
     * - use: optional
     * - maxLength: 19
     * - minLength: 19
     * @var string
     */
    public $exchangeRateDate;
    /**
     * Constructor method for approximateTotals
     * @uses ApproximateTotals::setTotalRegistered()
     * @uses ApproximateTotals::setTotalShopperPending()
     * @uses ApproximateTotals::setTotalAcquirerPending()
     * @uses ApproximateTotals::setTotalAcquirerApproved()
     * @uses ApproximateTotals::setTotalCaptured()
     * @uses ApproximateTotals::setTotalRefunded()
     * @uses ApproximateTotals::setTotalChargedback()
     * @uses ApproximateTotals::setTotalReversed()
     * @uses ApproximateTotals::setAny()
     * @uses ApproximateTotals::setExchangedTo()
     * @uses ApproximateTotals::setExchangeRateDate()
     * @param int $totalRegistered
     * @param int $totalShopperPending
     * @param int $totalAcquirerPending
     * @param int $totalAcquirerApproved
     * @param int $totalCaptured
     * @param int $totalRefunded
     * @param int $totalChargedback
     * @param int $totalReversed
     * @param \DOMDocument $any
     * @param string $exchangedTo
     * @param string $exchangeRateDate
     */
    public function __construct($totalRegistered = null, $totalShopperPending = null, $totalAcquirerPending = null, $totalAcquirerApproved = null, $totalCaptured = null, $totalRefunded = null, $totalChargedback = null, $totalReversed = null, \DOMDocument $any = null, $exchangedTo = null, $exchangeRateDate = null)
    {
        $this
            ->setTotalRegistered($totalRegistered)
            ->setTotalShopperPending($totalShopperPending)
            ->setTotalAcquirerPending($totalAcquirerPending)
            ->setTotalAcquirerApproved($totalAcquirerApproved)
            ->setTotalCaptured($totalCaptured)
            ->setTotalRefunded($totalRefunded)
            ->setTotalChargedback($totalChargedback)
            ->setTotalReversed($totalReversed)
            ->setAny($any)
            ->setExchangedTo($exchangedTo)
            ->setExchangeRateDate($exchangeRateDate);
    }
    /**
     * Get totalRegistered value
     * @return int
     */
    public function getTotalRegistered()
    {
        return $this->totalRegistered;
    }
    /**
     * Set totalRegistered value
     * @param int $totalRegistered
     * @return \Models\Docdata\StructType\ApproximateTotals
     */
    public function setTotalRegistered($totalRegistered = null)
    {
        // validation for constraint: int
        if (!is_null($totalRegistered) && !is_numeric($totalRegistered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalRegistered)), __LINE__);
        }
        $this->totalRegistered = $totalRegistered;
        return $this;
    }
    /**
     * Get totalShopperPending value
     * @return int
     */
    public function getTotalShopperPending()
    {
        return $this->totalShopperPending;
    }
    /**
     * Set totalShopperPending value
     * @param int $totalShopperPending
     * @return \Models\Docdata\StructType\ApproximateTotals
     */
    public function setTotalShopperPending($totalShopperPending = null)
    {
        // validation for constraint: int
        if (!is_null($totalShopperPending) && !is_numeric($totalShopperPending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalShopperPending)), __LINE__);
        }
        $this->totalShopperPending = $totalShopperPending;
        return $this;
    }
    /**
     * Get totalAcquirerPending value
     * @return int
     */
    public function getTotalAcquirerPending()
    {
        return $this->totalAcquirerPending;
    }
    /**
     * Set totalAcquirerPending value
     * @param int $totalAcquirerPending
     * @return \Models\Docdata\StructType\ApproximateTotals
     */
    public function setTotalAcquirerPending($totalAcquirerPending = null)
    {
        // validation for constraint: int
        if (!is_null($totalAcquirerPending) && !is_numeric($totalAcquirerPending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalAcquirerPending)), __LINE__);
        }
        $this->totalAcquirerPending = $totalAcquirerPending;
        return $this;
    }
    /**
     * Get totalAcquirerApproved value
     * @return int
     */
    public function getTotalAcquirerApproved()
    {
        return $this->totalAcquirerApproved;
    }
    /**
     * Set totalAcquirerApproved value
     * @param int $totalAcquirerApproved
     * @return \Models\Docdata\StructType\ApproximateTotals
     */
    public function setTotalAcquirerApproved($totalAcquirerApproved = null)
    {
        // validation for constraint: int
        if (!is_null($totalAcquirerApproved) && !is_numeric($totalAcquirerApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalAcquirerApproved)), __LINE__);
        }
        $this->totalAcquirerApproved = $totalAcquirerApproved;
        return $this;
    }
    /**
     * Get totalCaptured value
     * @return int
     */
    public function getTotalCaptured()
    {
        return $this->totalCaptured;
    }
    /**
     * Set totalCaptured value
     * @param int $totalCaptured
     * @return \Models\Docdata\StructType\ApproximateTotals
     */
    public function setTotalCaptured($totalCaptured = null)
    {
        // validation for constraint: int
        if (!is_null($totalCaptured) && !is_numeric($totalCaptured)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalCaptured)), __LINE__);
        }
        $this->totalCaptured = $totalCaptured;
        return $this;
    }
    /**
     * Get totalRefunded value
     * @return int
     */
    public function getTotalRefunded()
    {
        return $this->totalRefunded;
    }
    /**
     * Set totalRefunded value
     * @param int $totalRefunded
     * @return \Models\Docdata\StructType\ApproximateTotals
     */
    public function setTotalRefunded($totalRefunded = null)
    {
        // validation for constraint: int
        if (!is_null($totalRefunded) && !is_numeric($totalRefunded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalRefunded)), __LINE__);
        }
        $this->totalRefunded = $totalRefunded;
        return $this;
    }
    /**
     * Get totalChargedback value
     * @return int
     */
    public function getTotalChargedback()
    {
        return $this->totalChargedback;
    }
    /**
     * Set totalChargedback value
     * @param int $totalChargedback
     * @return \Models\Docdata\StructType\ApproximateTotals
     */
    public function setTotalChargedback($totalChargedback = null)
    {
        // validation for constraint: int
        if (!is_null($totalChargedback) && !is_numeric($totalChargedback)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalChargedback)), __LINE__);
        }
        $this->totalChargedback = $totalChargedback;
        return $this;
    }
    /**
     * Get totalReversed value
     * @return int
     */
    public function getTotalReversed()
    {
        return $this->totalReversed;
    }
    /**
     * Set totalReversed value
     * @param int $totalReversed
     * @return \Models\Docdata\StructType\ApproximateTotals
     */
    public function setTotalReversed($totalReversed = null)
    {
        // validation for constraint: int
        if (!is_null($totalReversed) && !is_numeric($totalReversed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalReversed)), __LINE__);
        }
        $this->totalReversed = $totalReversed;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\ApproximateTotals::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\ApproximateTotals
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Get exchangedTo value
     * @return string|null
     */
    public function getExchangedTo()
    {
        return $this->exchangedTo;
    }
    /**
     * Set exchangedTo value
     * @param string $exchangedTo
     * @return \Models\Docdata\StructType\ApproximateTotals
     */
    public function setExchangedTo($exchangedTo = null)
    {
        // validation for constraint: pattern
        if (is_scalar($exchangedTo) && !preg_match('/[A-Z][A-Z][A-Z]/', $exchangedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z][A-Z][A-Z]", "%s" given', var_export($exchangedTo, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($exchangedTo) && !is_string($exchangedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exchangedTo)), __LINE__);
        }
        $this->exchangedTo = $exchangedTo;
        return $this;
    }
    /**
     * Get exchangeRateDate value
     * @return string|null
     */
    public function getExchangeRateDate()
    {
        return $this->exchangeRateDate;
    }
    /**
     * Set exchangeRateDate value
     * @param string $exchangeRateDate
     * @return \Models\Docdata\StructType\ApproximateTotals
     */
    public function setExchangeRateDate($exchangeRateDate = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($exchangeRateDate) && strlen($exchangeRateDate) > 19) || (is_array($exchangeRateDate) && count($exchangeRateDate) > 19)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 19 element(s) or a scalar of 19 character(s) at most, "%d" length given', is_scalar($exchangeRateDate) ? strlen($exchangeRateDate) : count($exchangeRateDate)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($exchangeRateDate) && strlen($exchangeRateDate) < 19) || (is_array($exchangeRateDate) && count($exchangeRateDate) < 19)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 19 element(s) or a scalar of 19 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($exchangeRateDate) && !is_string($exchangeRateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exchangeRateDate)), __LINE__);
        }
        $this->exchangeRateDate = $exchangeRateDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\ApproximateTotals
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
