<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for amount StructType
 * Meta informations extracted from the WSDL
 * - documentation: Optional amount to refund | The amount in the minor unit for the given currency. (E.g. for EUR in cents)
 * - maxOccurs: 1
 * - minOccurs: 0
 * - type: ddp:amount
 * @subpackage Structs
 */
class Amount extends AbstractStructBase
{
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: ISO 4217:2008
     * - pattern: [A-Z][A-Z][A-Z]
     * @var string
     */
    public $currency;
    /**
     * The _
     * @var int
     */
    public $_;
    /**
     * Constructor method for amount
     * @uses Amount::setCurrency()
     * @uses Amount::set_()
     * @param string $currency
     * @param int $_
     */
    public function __construct($currency = null, $_ = null)
    {
        $this
            ->setCurrency($currency)
            ->set_($_);
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \Models\Docdata\StructType\Amount
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: pattern
        if (is_scalar($currency) && !preg_match('/[A-Z][A-Z][A-Z]/', $currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z][A-Z][A-Z]", "%s" given', var_export($currency, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get _ value
     * @return int|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param int $_
     * @return \Models\Docdata\StructType\Amount
     */
    public function set_($_ = null)
    {
        // validation for constraint: int
        if (!is_null($_) && !is_numeric($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\Amount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
