<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for threeDomainSecureAuthenticationResult StructType
 * Meta informations extracted from the WSDL
 * - documentation: The result of 3DS authentication done by the shopper.
 * @subpackage Structs
 */
class ThreeDomainSecureAuthenticationResult extends AbstractStructBase
{
    /**
     * The MD
     * Meta informations extracted from the WSDL
     * - documentation: The MD - Merchant Data from the 3DS request/response. This is a parameter from the original start response, so the same type is used.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 2048
     * - minLength: 1
     * @var string
     */
    public $MD;
    /**
     * The PARes
     * Meta informations extracted from the WSDL
     * - documentation: The Payment Authentication Response, containing all relevant data according to the 3DS specifications.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PARes;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for threeDomainSecureAuthenticationResult
     * @uses ThreeDomainSecureAuthenticationResult::setMD()
     * @uses ThreeDomainSecureAuthenticationResult::setPARes()
     * @uses ThreeDomainSecureAuthenticationResult::setAny()
     * @param string $mD
     * @param string $pARes
     * @param \DOMDocument $any
     */
    public function __construct($mD = null, $pARes = null, \DOMDocument $any = null)
    {
        $this
            ->setMD($mD)
            ->setPARes($pARes)
            ->setAny($any);
    }
    /**
     * Get MD value
     * @return string
     */
    public function getMD()
    {
        return $this->MD;
    }
    /**
     * Set MD value
     * @param string $mD
     * @return \Models\Docdata\StructType\ThreeDomainSecureAuthenticationResult
     */
    public function setMD($mD = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mD) && strlen($mD) > 2048) || (is_array($mD) && count($mD) > 2048)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2048 element(s) or a scalar of 2048 character(s) at most, "%d" length given', is_scalar($mD) ? strlen($mD) : count($mD)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($mD) && strlen($mD) < 1) || (is_array($mD) && count($mD) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mD) && !is_string($mD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mD)), __LINE__);
        }
        $this->MD = $mD;
        return $this;
    }
    /**
     * Get PARes value
     * @return string
     */
    public function getPARes()
    {
        return $this->PARes;
    }
    /**
     * Set PARes value
     * @param string $pARes
     * @return \Models\Docdata\StructType\ThreeDomainSecureAuthenticationResult
     */
    public function setPARes($pARes = null)
    {
        // validation for constraint: string
        if (!is_null($pARes) && !is_string($pARes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pARes)), __LINE__);
        }
        $this->PARes = $pARes;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\ThreeDomainSecureAuthenticationResult::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\ThreeDomainSecureAuthenticationResult
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\ThreeDomainSecureAuthenticationResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
