<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sepaBankAccount StructType
 * @subpackage Structs
 */
class SepaBankAccount extends AbstractStructBase
{
    /**
     * The holderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $holderName;
    /**
     * The holderCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $holderCity;
    /**
     * The holderCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Country
     */
    public $holderCountry;
    /**
     * The iban
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $iban;
    /**
     * The bic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $bic;
    /**
     * Constructor method for sepaBankAccount
     * @uses SepaBankAccount::setHolderName()
     * @uses SepaBankAccount::setHolderCity()
     * @uses SepaBankAccount::setHolderCountry()
     * @uses SepaBankAccount::setIban()
     * @uses SepaBankAccount::setBic()
     * @param string $holderName
     * @param string $holderCity
     * @param \Models\Docdata\StructType\Country $holderCountry
     * @param string $iban
     * @param string $bic
     */
    public function __construct($holderName = null, $holderCity = null, \Models\Docdata\StructType\Country $holderCountry = null, $iban = null, $bic = null)
    {
        $this
            ->setHolderName($holderName)
            ->setHolderCity($holderCity)
            ->setHolderCountry($holderCountry)
            ->setIban($iban)
            ->setBic($bic);
    }
    /**
     * Get holderName value
     * @return string
     */
    public function getHolderName()
    {
        return $this->holderName;
    }
    /**
     * Set holderName value
     * @param string $holderName
     * @return \Models\Docdata\StructType\SepaBankAccount
     */
    public function setHolderName($holderName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($holderName) && strlen($holderName) > 35) || (is_array($holderName) && count($holderName) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($holderName) ? strlen($holderName) : count($holderName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($holderName) && strlen($holderName) < 1) || (is_array($holderName) && count($holderName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($holderName) && !is_string($holderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($holderName)), __LINE__);
        }
        $this->holderName = $holderName;
        return $this;
    }
    /**
     * Get holderCity value
     * @return string
     */
    public function getHolderCity()
    {
        return $this->holderCity;
    }
    /**
     * Set holderCity value
     * @param string $holderCity
     * @return \Models\Docdata\StructType\SepaBankAccount
     */
    public function setHolderCity($holderCity = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($holderCity) && strlen($holderCity) > 35) || (is_array($holderCity) && count($holderCity) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($holderCity) ? strlen($holderCity) : count($holderCity)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($holderCity) && strlen($holderCity) < 1) || (is_array($holderCity) && count($holderCity) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($holderCity) && !is_string($holderCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($holderCity)), __LINE__);
        }
        $this->holderCity = $holderCity;
        return $this;
    }
    /**
     * Get holderCountry value
     * @return \Models\Docdata\StructType\Country
     */
    public function getHolderCountry()
    {
        return $this->holderCountry;
    }
    /**
     * Set holderCountry value
     * @param \Models\Docdata\StructType\Country $holderCountry
     * @return \Models\Docdata\StructType\SepaBankAccount
     */
    public function setHolderCountry(\Models\Docdata\StructType\Country $holderCountry = null)
    {
        $this->holderCountry = $holderCountry;
        return $this;
    }
    /**
     * Get iban value
     * @return string
     */
    public function getIban()
    {
        return $this->iban;
    }
    /**
     * Set iban value
     * @param string $iban
     * @return \Models\Docdata\StructType\SepaBankAccount
     */
    public function setIban($iban = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iban) && strlen($iban) > 35) || (is_array($iban) && count($iban) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($iban) ? strlen($iban) : count($iban)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iban) && strlen($iban) < 1) || (is_array($iban) && count($iban) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iban)), __LINE__);
        }
        $this->iban = $iban;
        return $this;
    }
    /**
     * Get bic value
     * @return string|null
     */
    public function getBic()
    {
        return $this->bic;
    }
    /**
     * Set bic value
     * @param string $bic
     * @return \Models\Docdata\StructType\SepaBankAccount
     */
    public function setBic($bic = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bic) && strlen($bic) > 35) || (is_array($bic) && count($bic) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($bic) ? strlen($bic) : count($bic)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bic) && strlen($bic) < 1) || (is_array($bic) && count($bic) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bic) && !is_string($bic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bic)), __LINE__);
        }
        $this->bic = $bic;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\SepaBankAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
