<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reversal StructType
 * @subpackage Structs
 */
class Reversal extends AbstractStructBase
{
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Amount
     */
    public $amount;
    /**
     * The reason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 250
     * - minLength: 1
     * @var string
     */
    public $reason;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for reversal
     * @uses Reversal::setAmount()
     * @uses Reversal::setReason()
     * @uses Reversal::setAny()
     * @param \Models\Docdata\StructType\Amount $amount
     * @param string $reason
     * @param \DOMDocument $any
     */
    public function __construct(\Models\Docdata\StructType\Amount $amount = null, $reason = null, \DOMDocument $any = null)
    {
        $this
            ->setAmount($amount)
            ->setReason($reason)
            ->setAny($any);
    }
    /**
     * Get amount value
     * @return \Models\Docdata\StructType\Amount
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param \Models\Docdata\StructType\Amount $amount
     * @return \Models\Docdata\StructType\Reversal
     */
    public function setAmount(\Models\Docdata\StructType\Amount $amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get reason value
     * @return string
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \Models\Docdata\StructType\Reversal
     */
    public function setReason($reason = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($reason) && strlen($reason) > 250) || (is_array($reason) && count($reason) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($reason) ? strlen($reason) : count($reason)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($reason) && strlen($reason) < 1) || (is_array($reason) && count($reason) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\Reversal::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\Reversal
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\Reversal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
