<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pointOfSalePaymentReceipt StructType
 * Meta informations extracted from the WSDL
 * - documentation: Point Of Sale payment receipt.
 * @subpackage Structs
 */
class PointOfSalePaymentReceipt extends AbstractStructBase
{
    /**
     * The formattedReceipt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\PointOfSalePaymentFormattedReceipt
     */
    public $formattedReceipt;
    /**
     * The receiptValues
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\PointOfSalePaymentReceiptValues
     */
    public $receiptValues;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for pointOfSalePaymentReceipt
     * @uses PointOfSalePaymentReceipt::setFormattedReceipt()
     * @uses PointOfSalePaymentReceipt::setReceiptValues()
     * @uses PointOfSalePaymentReceipt::setType()
     * @uses PointOfSalePaymentReceipt::setAny()
     * @param \Models\Docdata\StructType\PointOfSalePaymentFormattedReceipt $formattedReceipt
     * @param \Models\Docdata\StructType\PointOfSalePaymentReceiptValues $receiptValues
     * @param string $type
     * @param \DOMDocument $any
     */
    public function __construct(\Models\Docdata\StructType\PointOfSalePaymentFormattedReceipt $formattedReceipt = null, \Models\Docdata\StructType\PointOfSalePaymentReceiptValues $receiptValues = null, $type = null, \DOMDocument $any = null)
    {
        $this
            ->setFormattedReceipt($formattedReceipt)
            ->setReceiptValues($receiptValues)
            ->setType($type)
            ->setAny($any);
    }
    /**
     * Get formattedReceipt value
     * @return \Models\Docdata\StructType\PointOfSalePaymentFormattedReceipt
     */
    public function getFormattedReceipt()
    {
        return $this->formattedReceipt;
    }
    /**
     * Set formattedReceipt value
     * @param \Models\Docdata\StructType\PointOfSalePaymentFormattedReceipt $formattedReceipt
     * @return \Models\Docdata\StructType\PointOfSalePaymentReceipt
     */
    public function setFormattedReceipt(\Models\Docdata\StructType\PointOfSalePaymentFormattedReceipt $formattedReceipt = null)
    {
        $this->formattedReceipt = $formattedReceipt;
        return $this;
    }
    /**
     * Get receiptValues value
     * @return \Models\Docdata\StructType\PointOfSalePaymentReceiptValues
     */
    public function getReceiptValues()
    {
        return $this->receiptValues;
    }
    /**
     * Set receiptValues value
     * @param \Models\Docdata\StructType\PointOfSalePaymentReceiptValues $receiptValues
     * @return \Models\Docdata\StructType\PointOfSalePaymentReceipt
     */
    public function setReceiptValues(\Models\Docdata\StructType\PointOfSalePaymentReceiptValues $receiptValues = null)
    {
        $this->receiptValues = $receiptValues;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \Models\Docdata\EnumType\PointOfSalePaymentReceiptType::valueIsValid()
     * @uses \Models\Docdata\EnumType\PointOfSalePaymentReceiptType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Models\Docdata\StructType\PointOfSalePaymentReceipt
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Models\Docdata\EnumType\PointOfSalePaymentReceiptType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \Models\Docdata\EnumType\PointOfSalePaymentReceiptType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\PointOfSalePaymentReceipt::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\PointOfSalePaymentReceipt
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\PointOfSalePaymentReceipt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
