<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Extended payment information e.g. risk check scores and payment-specific information. | Note: there is no paymentInfo for PayPal, PaySafeCard, GiroPay, EPS and PostFinance. They only provide their PaymentMethodName. See the
 * payment-element.
 * @subpackage Structs
 */
class PaymentInfo extends AbstractStructBase
{
    /**
     * The amexPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\AmexPaymentInfo
     */
    public $amexPaymentInfo;
    /**
     * The masterCardPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\MasterCardPaymentInfo
     */
    public $masterCardPaymentInfo;
    /**
     * The visaPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\VisaPaymentInfo
     */
    public $visaPaymentInfo;
    /**
     * The bankTransferPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\BankTransferPaymentInfo
     */
    public $bankTransferPaymentInfo;
    /**
     * The maestroPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\MaestroPaymentInfo
     */
    public $maestroPaymentInfo;
    /**
     * The misterCashPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\MisterCashPaymentInfo
     */
    public $misterCashPaymentInfo;
    /**
     * The giftCardPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\GiftCardPaymentInfo
     */
    public $giftCardPaymentInfo;
    /**
     * The iDealPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\IDealPaymentInfo
     */
    public $iDealPaymentInfo;
    /**
     * The afterpayOpenInvoicePaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\OpenInvoicePaymentInfo
     */
    public $afterpayOpenInvoicePaymentInfo;
    /**
     * The afterpayDirectDebitPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\OpenInvoicePaymentInfo
     */
    public $afterpayDirectDebitPaymentInfo;
    /**
     * The klarnaInvoicePaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\OpenInvoicePaymentInfo
     */
    public $klarnaInvoicePaymentInfo;
    /**
     * The klarnaAccountPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\OpenInvoicePaymentInfo
     */
    public $klarnaAccountPaymentInfo;
    /**
     * The elvPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\ElvPaymentInfo
     */
    public $elvPaymentInfo;
    /**
     * The sepaDirectDebitPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\SepaDirectDebitPaymentInfo
     */
    public $sepaDirectDebitPaymentInfo;
    /**
     * The pointOfSalePaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\PointOfSalePaymentInfo
     */
    public $pointOfSalePaymentInfo;
    /**
     * The offlinePaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\OfflinePaymentInfo
     */
    public $offlinePaymentInfo;
    /**
     * The sofortUeberweisungPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\SofortPaymentInfo
     */
    public $sofortUeberweisungPaymentInfo;
    /**
     * The eBankingPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\SofortPaymentInfo
     */
    public $eBankingPaymentInfo;
    /**
     * The systemPaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\SystemPaymentInfo
     */
    public $systemPaymentInfo;
    /**
     * The riskChecks
     * Meta informations extracted from the WSDL
     * - documentation: Risk checks are controls which can prevent fraud. They can be configured in the back office.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\RiskCheck
     */
    public $riskChecks;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for paymentInfo
     * @uses PaymentInfo::setAmexPaymentInfo()
     * @uses PaymentInfo::setMasterCardPaymentInfo()
     * @uses PaymentInfo::setVisaPaymentInfo()
     * @uses PaymentInfo::setBankTransferPaymentInfo()
     * @uses PaymentInfo::setMaestroPaymentInfo()
     * @uses PaymentInfo::setMisterCashPaymentInfo()
     * @uses PaymentInfo::setGiftCardPaymentInfo()
     * @uses PaymentInfo::setIDealPaymentInfo()
     * @uses PaymentInfo::setAfterpayOpenInvoicePaymentInfo()
     * @uses PaymentInfo::setAfterpayDirectDebitPaymentInfo()
     * @uses PaymentInfo::setKlarnaInvoicePaymentInfo()
     * @uses PaymentInfo::setKlarnaAccountPaymentInfo()
     * @uses PaymentInfo::setElvPaymentInfo()
     * @uses PaymentInfo::setSepaDirectDebitPaymentInfo()
     * @uses PaymentInfo::setPointOfSalePaymentInfo()
     * @uses PaymentInfo::setOfflinePaymentInfo()
     * @uses PaymentInfo::setSofortUeberweisungPaymentInfo()
     * @uses PaymentInfo::setEBankingPaymentInfo()
     * @uses PaymentInfo::setSystemPaymentInfo()
     * @uses PaymentInfo::setRiskChecks()
     * @uses PaymentInfo::setAny()
     * @param \Models\Docdata\StructType\AmexPaymentInfo $amexPaymentInfo
     * @param \Models\Docdata\StructType\MasterCardPaymentInfo $masterCardPaymentInfo
     * @param \Models\Docdata\StructType\VisaPaymentInfo $visaPaymentInfo
     * @param \Models\Docdata\StructType\BankTransferPaymentInfo $bankTransferPaymentInfo
     * @param \Models\Docdata\StructType\MaestroPaymentInfo $maestroPaymentInfo
     * @param \Models\Docdata\StructType\MisterCashPaymentInfo $misterCashPaymentInfo
     * @param \Models\Docdata\StructType\GiftCardPaymentInfo $giftCardPaymentInfo
     * @param \Models\Docdata\StructType\IDealPaymentInfo $iDealPaymentInfo
     * @param \Models\Docdata\StructType\OpenInvoicePaymentInfo $afterpayOpenInvoicePaymentInfo
     * @param \Models\Docdata\StructType\OpenInvoicePaymentInfo $afterpayDirectDebitPaymentInfo
     * @param \Models\Docdata\StructType\OpenInvoicePaymentInfo $klarnaInvoicePaymentInfo
     * @param \Models\Docdata\StructType\OpenInvoicePaymentInfo $klarnaAccountPaymentInfo
     * @param \Models\Docdata\StructType\ElvPaymentInfo $elvPaymentInfo
     * @param \Models\Docdata\StructType\SepaDirectDebitPaymentInfo $sepaDirectDebitPaymentInfo
     * @param \Models\Docdata\StructType\PointOfSalePaymentInfo $pointOfSalePaymentInfo
     * @param \Models\Docdata\StructType\OfflinePaymentInfo $offlinePaymentInfo
     * @param \Models\Docdata\StructType\SofortPaymentInfo $sofortUeberweisungPaymentInfo
     * @param \Models\Docdata\StructType\SofortPaymentInfo $eBankingPaymentInfo
     * @param \Models\Docdata\StructType\SystemPaymentInfo $systemPaymentInfo
     * @param \Models\Docdata\StructType\RiskCheck $riskChecks
     * @param \DOMDocument $any
     */
    public function __construct(\Models\Docdata\StructType\AmexPaymentInfo $amexPaymentInfo = null, \Models\Docdata\StructType\MasterCardPaymentInfo $masterCardPaymentInfo = null, \Models\Docdata\StructType\VisaPaymentInfo $visaPaymentInfo = null, \Models\Docdata\StructType\BankTransferPaymentInfo $bankTransferPaymentInfo = null, \Models\Docdata\StructType\MaestroPaymentInfo $maestroPaymentInfo = null, \Models\Docdata\StructType\MisterCashPaymentInfo $misterCashPaymentInfo = null, \Models\Docdata\StructType\GiftCardPaymentInfo $giftCardPaymentInfo = null, \Models\Docdata\StructType\IDealPaymentInfo $iDealPaymentInfo = null, \Models\Docdata\StructType\OpenInvoicePaymentInfo $afterpayOpenInvoicePaymentInfo = null, \Models\Docdata\StructType\OpenInvoicePaymentInfo $afterpayDirectDebitPaymentInfo = null, \Models\Docdata\StructType\OpenInvoicePaymentInfo $klarnaInvoicePaymentInfo = null, \Models\Docdata\StructType\OpenInvoicePaymentInfo $klarnaAccountPaymentInfo = null, \Models\Docdata\StructType\ElvPaymentInfo $elvPaymentInfo = null, \Models\Docdata\StructType\SepaDirectDebitPaymentInfo $sepaDirectDebitPaymentInfo = null, \Models\Docdata\StructType\PointOfSalePaymentInfo $pointOfSalePaymentInfo = null, \Models\Docdata\StructType\OfflinePaymentInfo $offlinePaymentInfo = null, \Models\Docdata\StructType\SofortPaymentInfo $sofortUeberweisungPaymentInfo = null, \Models\Docdata\StructType\SofortPaymentInfo $eBankingPaymentInfo = null, \Models\Docdata\StructType\SystemPaymentInfo $systemPaymentInfo = null, \Models\Docdata\StructType\RiskCheck $riskChecks = null, \DOMDocument $any = null)
    {
        $this
            ->setAmexPaymentInfo($amexPaymentInfo)
            ->setMasterCardPaymentInfo($masterCardPaymentInfo)
            ->setVisaPaymentInfo($visaPaymentInfo)
            ->setBankTransferPaymentInfo($bankTransferPaymentInfo)
            ->setMaestroPaymentInfo($maestroPaymentInfo)
            ->setMisterCashPaymentInfo($misterCashPaymentInfo)
            ->setGiftCardPaymentInfo($giftCardPaymentInfo)
            ->setIDealPaymentInfo($iDealPaymentInfo)
            ->setAfterpayOpenInvoicePaymentInfo($afterpayOpenInvoicePaymentInfo)
            ->setAfterpayDirectDebitPaymentInfo($afterpayDirectDebitPaymentInfo)
            ->setKlarnaInvoicePaymentInfo($klarnaInvoicePaymentInfo)
            ->setKlarnaAccountPaymentInfo($klarnaAccountPaymentInfo)
            ->setElvPaymentInfo($elvPaymentInfo)
            ->setSepaDirectDebitPaymentInfo($sepaDirectDebitPaymentInfo)
            ->setPointOfSalePaymentInfo($pointOfSalePaymentInfo)
            ->setOfflinePaymentInfo($offlinePaymentInfo)
            ->setSofortUeberweisungPaymentInfo($sofortUeberweisungPaymentInfo)
            ->setEBankingPaymentInfo($eBankingPaymentInfo)
            ->setSystemPaymentInfo($systemPaymentInfo)
            ->setRiskChecks($riskChecks)
            ->setAny($any);
    }
    /**
     * Get amexPaymentInfo value
     * @return \Models\Docdata\StructType\AmexPaymentInfo
     */
    public function getAmexPaymentInfo()
    {
        return $this->amexPaymentInfo;
    }
    /**
     * Set amexPaymentInfo value
     * @param \Models\Docdata\StructType\AmexPaymentInfo $amexPaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setAmexPaymentInfo(\Models\Docdata\StructType\AmexPaymentInfo $amexPaymentInfo = null)
    {
        $this->amexPaymentInfo = $amexPaymentInfo;
        return $this;
    }
    /**
     * Get masterCardPaymentInfo value
     * @return \Models\Docdata\StructType\MasterCardPaymentInfo
     */
    public function getMasterCardPaymentInfo()
    {
        return $this->masterCardPaymentInfo;
    }
    /**
     * Set masterCardPaymentInfo value
     * @param \Models\Docdata\StructType\MasterCardPaymentInfo $masterCardPaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setMasterCardPaymentInfo(\Models\Docdata\StructType\MasterCardPaymentInfo $masterCardPaymentInfo = null)
    {
        $this->masterCardPaymentInfo = $masterCardPaymentInfo;
        return $this;
    }
    /**
     * Get visaPaymentInfo value
     * @return \Models\Docdata\StructType\VisaPaymentInfo
     */
    public function getVisaPaymentInfo()
    {
        return $this->visaPaymentInfo;
    }
    /**
     * Set visaPaymentInfo value
     * @param \Models\Docdata\StructType\VisaPaymentInfo $visaPaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setVisaPaymentInfo(\Models\Docdata\StructType\VisaPaymentInfo $visaPaymentInfo = null)
    {
        $this->visaPaymentInfo = $visaPaymentInfo;
        return $this;
    }
    /**
     * Get bankTransferPaymentInfo value
     * @return \Models\Docdata\StructType\BankTransferPaymentInfo
     */
    public function getBankTransferPaymentInfo()
    {
        return $this->bankTransferPaymentInfo;
    }
    /**
     * Set bankTransferPaymentInfo value
     * @param \Models\Docdata\StructType\BankTransferPaymentInfo $bankTransferPaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setBankTransferPaymentInfo(\Models\Docdata\StructType\BankTransferPaymentInfo $bankTransferPaymentInfo = null)
    {
        $this->bankTransferPaymentInfo = $bankTransferPaymentInfo;
        return $this;
    }
    /**
     * Get maestroPaymentInfo value
     * @return \Models\Docdata\StructType\MaestroPaymentInfo
     */
    public function getMaestroPaymentInfo()
    {
        return $this->maestroPaymentInfo;
    }
    /**
     * Set maestroPaymentInfo value
     * @param \Models\Docdata\StructType\MaestroPaymentInfo $maestroPaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setMaestroPaymentInfo(\Models\Docdata\StructType\MaestroPaymentInfo $maestroPaymentInfo = null)
    {
        $this->maestroPaymentInfo = $maestroPaymentInfo;
        return $this;
    }
    /**
     * Get misterCashPaymentInfo value
     * @return \Models\Docdata\StructType\MisterCashPaymentInfo
     */
    public function getMisterCashPaymentInfo()
    {
        return $this->misterCashPaymentInfo;
    }
    /**
     * Set misterCashPaymentInfo value
     * @param \Models\Docdata\StructType\MisterCashPaymentInfo $misterCashPaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setMisterCashPaymentInfo(\Models\Docdata\StructType\MisterCashPaymentInfo $misterCashPaymentInfo = null)
    {
        $this->misterCashPaymentInfo = $misterCashPaymentInfo;
        return $this;
    }
    /**
     * Get giftCardPaymentInfo value
     * @return \Models\Docdata\StructType\GiftCardPaymentInfo
     */
    public function getGiftCardPaymentInfo()
    {
        return $this->giftCardPaymentInfo;
    }
    /**
     * Set giftCardPaymentInfo value
     * @param \Models\Docdata\StructType\GiftCardPaymentInfo $giftCardPaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setGiftCardPaymentInfo(\Models\Docdata\StructType\GiftCardPaymentInfo $giftCardPaymentInfo = null)
    {
        $this->giftCardPaymentInfo = $giftCardPaymentInfo;
        return $this;
    }
    /**
     * Get iDealPaymentInfo value
     * @return \Models\Docdata\StructType\IDealPaymentInfo
     */
    public function getIDealPaymentInfo()
    {
        return $this->iDealPaymentInfo;
    }
    /**
     * Set iDealPaymentInfo value
     * @param \Models\Docdata\StructType\IDealPaymentInfo $iDealPaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setIDealPaymentInfo(\Models\Docdata\StructType\IDealPaymentInfo $iDealPaymentInfo = null)
    {
        $this->iDealPaymentInfo = $iDealPaymentInfo;
        return $this;
    }
    /**
     * Get afterpayOpenInvoicePaymentInfo value
     * @return \Models\Docdata\StructType\OpenInvoicePaymentInfo
     */
    public function getAfterpayOpenInvoicePaymentInfo()
    {
        return $this->afterpayOpenInvoicePaymentInfo;
    }
    /**
     * Set afterpayOpenInvoicePaymentInfo value
     * @param \Models\Docdata\StructType\OpenInvoicePaymentInfo $afterpayOpenInvoicePaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setAfterpayOpenInvoicePaymentInfo(\Models\Docdata\StructType\OpenInvoicePaymentInfo $afterpayOpenInvoicePaymentInfo = null)
    {
        $this->afterpayOpenInvoicePaymentInfo = $afterpayOpenInvoicePaymentInfo;
        return $this;
    }
    /**
     * Get afterpayDirectDebitPaymentInfo value
     * @return \Models\Docdata\StructType\OpenInvoicePaymentInfo
     */
    public function getAfterpayDirectDebitPaymentInfo()
    {
        return $this->afterpayDirectDebitPaymentInfo;
    }
    /**
     * Set afterpayDirectDebitPaymentInfo value
     * @param \Models\Docdata\StructType\OpenInvoicePaymentInfo $afterpayDirectDebitPaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setAfterpayDirectDebitPaymentInfo(\Models\Docdata\StructType\OpenInvoicePaymentInfo $afterpayDirectDebitPaymentInfo = null)
    {
        $this->afterpayDirectDebitPaymentInfo = $afterpayDirectDebitPaymentInfo;
        return $this;
    }
    /**
     * Get klarnaInvoicePaymentInfo value
     * @return \Models\Docdata\StructType\OpenInvoicePaymentInfo
     */
    public function getKlarnaInvoicePaymentInfo()
    {
        return $this->klarnaInvoicePaymentInfo;
    }
    /**
     * Set klarnaInvoicePaymentInfo value
     * @param \Models\Docdata\StructType\OpenInvoicePaymentInfo $klarnaInvoicePaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setKlarnaInvoicePaymentInfo(\Models\Docdata\StructType\OpenInvoicePaymentInfo $klarnaInvoicePaymentInfo = null)
    {
        $this->klarnaInvoicePaymentInfo = $klarnaInvoicePaymentInfo;
        return $this;
    }
    /**
     * Get klarnaAccountPaymentInfo value
     * @return \Models\Docdata\StructType\OpenInvoicePaymentInfo
     */
    public function getKlarnaAccountPaymentInfo()
    {
        return $this->klarnaAccountPaymentInfo;
    }
    /**
     * Set klarnaAccountPaymentInfo value
     * @param \Models\Docdata\StructType\OpenInvoicePaymentInfo $klarnaAccountPaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setKlarnaAccountPaymentInfo(\Models\Docdata\StructType\OpenInvoicePaymentInfo $klarnaAccountPaymentInfo = null)
    {
        $this->klarnaAccountPaymentInfo = $klarnaAccountPaymentInfo;
        return $this;
    }
    /**
     * Get elvPaymentInfo value
     * @return \Models\Docdata\StructType\ElvPaymentInfo
     */
    public function getElvPaymentInfo()
    {
        return $this->elvPaymentInfo;
    }
    /**
     * Set elvPaymentInfo value
     * @param \Models\Docdata\StructType\ElvPaymentInfo $elvPaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setElvPaymentInfo(\Models\Docdata\StructType\ElvPaymentInfo $elvPaymentInfo = null)
    {
        $this->elvPaymentInfo = $elvPaymentInfo;
        return $this;
    }
    /**
     * Get sepaDirectDebitPaymentInfo value
     * @return \Models\Docdata\StructType\SepaDirectDebitPaymentInfo
     */
    public function getSepaDirectDebitPaymentInfo()
    {
        return $this->sepaDirectDebitPaymentInfo;
    }
    /**
     * Set sepaDirectDebitPaymentInfo value
     * @param \Models\Docdata\StructType\SepaDirectDebitPaymentInfo $sepaDirectDebitPaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setSepaDirectDebitPaymentInfo(\Models\Docdata\StructType\SepaDirectDebitPaymentInfo $sepaDirectDebitPaymentInfo = null)
    {
        $this->sepaDirectDebitPaymentInfo = $sepaDirectDebitPaymentInfo;
        return $this;
    }
    /**
     * Get pointOfSalePaymentInfo value
     * @return \Models\Docdata\StructType\PointOfSalePaymentInfo
     */
    public function getPointOfSalePaymentInfo()
    {
        return $this->pointOfSalePaymentInfo;
    }
    /**
     * Set pointOfSalePaymentInfo value
     * @param \Models\Docdata\StructType\PointOfSalePaymentInfo $pointOfSalePaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setPointOfSalePaymentInfo(\Models\Docdata\StructType\PointOfSalePaymentInfo $pointOfSalePaymentInfo = null)
    {
        $this->pointOfSalePaymentInfo = $pointOfSalePaymentInfo;
        return $this;
    }
    /**
     * Get offlinePaymentInfo value
     * @return \Models\Docdata\StructType\OfflinePaymentInfo
     */
    public function getOfflinePaymentInfo()
    {
        return $this->offlinePaymentInfo;
    }
    /**
     * Set offlinePaymentInfo value
     * @param \Models\Docdata\StructType\OfflinePaymentInfo $offlinePaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setOfflinePaymentInfo(\Models\Docdata\StructType\OfflinePaymentInfo $offlinePaymentInfo = null)
    {
        $this->offlinePaymentInfo = $offlinePaymentInfo;
        return $this;
    }
    /**
     * Get sofortUeberweisungPaymentInfo value
     * @return \Models\Docdata\StructType\SofortPaymentInfo
     */
    public function getSofortUeberweisungPaymentInfo()
    {
        return $this->sofortUeberweisungPaymentInfo;
    }
    /**
     * Set sofortUeberweisungPaymentInfo value
     * @param \Models\Docdata\StructType\SofortPaymentInfo $sofortUeberweisungPaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setSofortUeberweisungPaymentInfo(\Models\Docdata\StructType\SofortPaymentInfo $sofortUeberweisungPaymentInfo = null)
    {
        $this->sofortUeberweisungPaymentInfo = $sofortUeberweisungPaymentInfo;
        return $this;
    }
    /**
     * Get eBankingPaymentInfo value
     * @return \Models\Docdata\StructType\SofortPaymentInfo
     */
    public function getEBankingPaymentInfo()
    {
        return $this->eBankingPaymentInfo;
    }
    /**
     * Set eBankingPaymentInfo value
     * @param \Models\Docdata\StructType\SofortPaymentInfo $eBankingPaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setEBankingPaymentInfo(\Models\Docdata\StructType\SofortPaymentInfo $eBankingPaymentInfo = null)
    {
        $this->eBankingPaymentInfo = $eBankingPaymentInfo;
        return $this;
    }
    /**
     * Get systemPaymentInfo value
     * @return \Models\Docdata\StructType\SystemPaymentInfo
     */
    public function getSystemPaymentInfo()
    {
        return $this->systemPaymentInfo;
    }
    /**
     * Set systemPaymentInfo value
     * @param \Models\Docdata\StructType\SystemPaymentInfo $systemPaymentInfo
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setSystemPaymentInfo(\Models\Docdata\StructType\SystemPaymentInfo $systemPaymentInfo = null)
    {
        $this->systemPaymentInfo = $systemPaymentInfo;
        return $this;
    }
    /**
     * Get riskChecks value
     * @return \Models\Docdata\StructType\RiskCheck|null
     */
    public function getRiskChecks()
    {
        return $this->riskChecks;
    }
    /**
     * Set riskChecks value
     * @param \Models\Docdata\StructType\RiskCheck $riskChecks
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setRiskChecks(\Models\Docdata\StructType\RiskCheck $riskChecks = null)
    {
        $this->riskChecks = $riskChecks;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\PaymentInfo::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\PaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
