<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for openInvoicePaymentInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Open invoice payment information.
 * @subpackage Structs
 */
class OpenInvoicePaymentInfo extends AbstractStructBase
{
    /**
     * The invoiceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $invoiceNumber;
    /**
     * The reservationNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $reservationNumber;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for openInvoicePaymentInfo
     * @uses OpenInvoicePaymentInfo::setInvoiceNumber()
     * @uses OpenInvoicePaymentInfo::setReservationNumber()
     * @uses OpenInvoicePaymentInfo::setAny()
     * @param string $invoiceNumber
     * @param string $reservationNumber
     * @param \DOMDocument $any
     */
    public function __construct($invoiceNumber = null, $reservationNumber = null, \DOMDocument $any = null)
    {
        $this
            ->setInvoiceNumber($invoiceNumber)
            ->setReservationNumber($reservationNumber)
            ->setAny($any);
    }
    /**
     * Get invoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->invoiceNumber;
    }
    /**
     * Set invoiceNumber value
     * @param string $invoiceNumber
     * @return \Models\Docdata\StructType\OpenInvoicePaymentInfo
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($invoiceNumber) && strlen($invoiceNumber) > 50) || (is_array($invoiceNumber) && count($invoiceNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($invoiceNumber) ? strlen($invoiceNumber) : count($invoiceNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($invoiceNumber) && strlen($invoiceNumber) < 1) || (is_array($invoiceNumber) && count($invoiceNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceNumber)), __LINE__);
        }
        $this->invoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get reservationNumber value
     * @return string|null
     */
    public function getReservationNumber()
    {
        return $this->reservationNumber;
    }
    /**
     * Set reservationNumber value
     * @param string $reservationNumber
     * @return \Models\Docdata\StructType\OpenInvoicePaymentInfo
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($reservationNumber) && strlen($reservationNumber) > 50) || (is_array($reservationNumber) && count($reservationNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($reservationNumber) ? strlen($reservationNumber) : count($reservationNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($reservationNumber) && strlen($reservationNumber) < 1) || (is_array($reservationNumber) && count($reservationNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($reservationNumber) && !is_string($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationNumber)), __LINE__);
        }
        $this->reservationNumber = $reservationNumber;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\OpenInvoicePaymentInfo::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\OpenInvoicePaymentInfo
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\OpenInvoicePaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
