<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for offlinePaymentInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Offline payment information.
 * @subpackage Structs
 */
class OfflinePaymentInfo extends AbstractStructBase
{
    /**
     * The method
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $method;
    /**
     * The register
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\Register
     */
    public $register;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for offlinePaymentInfo
     * @uses OfflinePaymentInfo::setMethod()
     * @uses OfflinePaymentInfo::setRegister()
     * @uses OfflinePaymentInfo::setAny()
     * @param string $method
     * @param \Models\Docdata\StructType\Register $register
     * @param \DOMDocument $any
     */
    public function __construct($method = null, \Models\Docdata\StructType\Register $register = null, \DOMDocument $any = null)
    {
        $this
            ->setMethod($method)
            ->setRegister($register)
            ->setAny($any);
    }
    /**
     * Get method value
     * @return string
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @param string $method
     * @return \Models\Docdata\StructType\OfflinePaymentInfo
     */
    public function setMethod($method = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($method) && strlen($method) > 50) || (is_array($method) && count($method) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($method) ? strlen($method) : count($method)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($method) && strlen($method) < 1) || (is_array($method) && count($method) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($method) && !is_string($method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($method)), __LINE__);
        }
        $this->method = $method;
        return $this;
    }
    /**
     * Get register value
     * @return \Models\Docdata\StructType\Register|null
     */
    public function getRegister()
    {
        return $this->register;
    }
    /**
     * Set register value
     * @param \Models\Docdata\StructType\Register $register
     * @return \Models\Docdata\StructType\OfflinePaymentInfo
     */
    public function setRegister(\Models\Docdata\StructType\Register $register = null)
    {
        $this->register = $register;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\OfflinePaymentInfo::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\OfflinePaymentInfo
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\OfflinePaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
