<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for listPaymentMethodsSuccess StructType
 * @subpackage Structs
 */
class ListPaymentMethodsSuccess extends AbstractStructBase
{
    /**
     * The success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Success
     */
    public $success;
    /**
     * The paymentMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\PaymentMethod[]
     */
    public $paymentMethod;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for listPaymentMethodsSuccess
     * @uses ListPaymentMethodsSuccess::setSuccess()
     * @uses ListPaymentMethodsSuccess::setPaymentMethod()
     * @uses ListPaymentMethodsSuccess::setAny()
     * @param \Models\Docdata\StructType\Success $success
     * @param \Models\Docdata\StructType\PaymentMethod[] $paymentMethod
     * @param \DOMDocument $any
     */
    public function __construct(\Models\Docdata\StructType\Success $success = null, array $paymentMethod = array(), \DOMDocument $any = null)
    {
        $this
            ->setSuccess($success)
            ->setPaymentMethod($paymentMethod)
            ->setAny($any);
    }
    /**
     * Get success value
     * @return \Models\Docdata\StructType\Success
     */
    public function getSuccess()
    {
        return $this->success;
    }
    /**
     * Set success value
     * @param \Models\Docdata\StructType\Success $success
     * @return \Models\Docdata\StructType\ListPaymentMethodsSuccess
     */
    public function setSuccess(\Models\Docdata\StructType\Success $success = null)
    {
        $this->success = $success;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return \Models\Docdata\StructType\PaymentMethod[]|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @throws \InvalidArgumentException
     * @param \Models\Docdata\StructType\PaymentMethod[] $paymentMethod
     * @return \Models\Docdata\StructType\ListPaymentMethodsSuccess
     */
    public function setPaymentMethod(array $paymentMethod = array())
    {
        foreach ($paymentMethod as $listPaymentMethodsSuccessPaymentMethodItem) {
            // validation for constraint: itemType
            if (!$listPaymentMethodsSuccessPaymentMethodItem instanceof \Models\Docdata\StructType\PaymentMethod) {
                throw new \InvalidArgumentException(sprintf('The paymentMethod property can only contain items of \Models\Docdata\StructType\PaymentMethod, "%s" given', is_object($listPaymentMethodsSuccessPaymentMethodItem) ? get_class($listPaymentMethodsSuccessPaymentMethodItem) : gettype($listPaymentMethodsSuccessPaymentMethodItem)), __LINE__);
            }
        }
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Add item to paymentMethod value
     * @throws \InvalidArgumentException
     * @param \Models\Docdata\StructType\PaymentMethod $item
     * @return \Models\Docdata\StructType\ListPaymentMethodsSuccess
     */
    public function addToPaymentMethod(\Models\Docdata\StructType\PaymentMethod $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Models\Docdata\StructType\PaymentMethod) {
            throw new \InvalidArgumentException(sprintf('The paymentMethod property can only contain items of \Models\Docdata\StructType\PaymentMethod, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->paymentMethod[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\ListPaymentMethodsSuccess::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\ListPaymentMethodsSuccess
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\ListPaymentMethodsSuccess
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
