<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for iDealPaymentInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Payment information concerning iDEAL.
 * @subpackage Structs
 */
class IDealPaymentInfo extends AbstractStructBase
{
    /**
     * The issuerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $issuerId;
    /**
     * The holderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $holderName;
    /**
     * The shopperBankAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Models\Docdata\StructType\ShopperBankAccount
     */
    public $shopperBankAccount;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for iDealPaymentInfo
     * @uses IDealPaymentInfo::setIssuerId()
     * @uses IDealPaymentInfo::setHolderName()
     * @uses IDealPaymentInfo::setShopperBankAccount()
     * @uses IDealPaymentInfo::setAny()
     * @param string $issuerId
     * @param string $holderName
     * @param \Models\Docdata\StructType\ShopperBankAccount $shopperBankAccount
     * @param \DOMDocument $any
     */
    public function __construct($issuerId = null, $holderName = null, \Models\Docdata\StructType\ShopperBankAccount $shopperBankAccount = null, \DOMDocument $any = null)
    {
        $this
            ->setIssuerId($issuerId)
            ->setHolderName($holderName)
            ->setShopperBankAccount($shopperBankAccount)
            ->setAny($any);
    }
    /**
     * Get issuerId value
     * @return string|null
     */
    public function getIssuerId()
    {
        return $this->issuerId;
    }
    /**
     * Set issuerId value
     * @param string $issuerId
     * @return \Models\Docdata\StructType\IDealPaymentInfo
     */
    public function setIssuerId($issuerId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($issuerId) && strlen($issuerId) > 50) || (is_array($issuerId) && count($issuerId) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($issuerId) ? strlen($issuerId) : count($issuerId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($issuerId) && strlen($issuerId) < 1) || (is_array($issuerId) && count($issuerId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($issuerId) && !is_string($issuerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuerId)), __LINE__);
        }
        $this->issuerId = $issuerId;
        return $this;
    }
    /**
     * Get holderName value
     * @return string|null
     */
    public function getHolderName()
    {
        return $this->holderName;
    }
    /**
     * Set holderName value
     * @param string $holderName
     * @return \Models\Docdata\StructType\IDealPaymentInfo
     */
    public function setHolderName($holderName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($holderName) && strlen($holderName) > 35) || (is_array($holderName) && count($holderName) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($holderName) ? strlen($holderName) : count($holderName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($holderName) && strlen($holderName) < 1) || (is_array($holderName) && count($holderName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($holderName) && !is_string($holderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($holderName)), __LINE__);
        }
        $this->holderName = $holderName;
        return $this;
    }
    /**
     * Get shopperBankAccount value
     * @return \Models\Docdata\StructType\ShopperBankAccount|null
     */
    public function getShopperBankAccount()
    {
        return $this->shopperBankAccount;
    }
    /**
     * Set shopperBankAccount value
     * @param \Models\Docdata\StructType\ShopperBankAccount $shopperBankAccount
     * @return \Models\Docdata\StructType\IDealPaymentInfo
     */
    public function setShopperBankAccount(\Models\Docdata\StructType\ShopperBankAccount $shopperBankAccount = null)
    {
        $this->shopperBankAccount = $shopperBankAccount;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Models\Docdata\StructType\IDealPaymentInfo::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Models\Docdata\StructType\IDealPaymentInfo
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\IDealPaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
