<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Response of the payment order create request.
 * @subpackage Structs
 */
class CreateResponse extends AbstractStructBase
{
    /**
     * The createErrors
     * Meta informations extracted from the WSDL
     * - documentation: An error occurred. No payment order was created.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\CreateErrors
     */
    public $createErrors;
    /**
     * The createSuccess
     * Meta informations extracted from the WSDL
     * - documentation: A payment order was successfully created. This does not mean that the whole request was processed successfully! The paymentResponse (see child elements) can still contain errors.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\CreateSuccess
     */
    public $createSuccess;
    /**
     * The ddpXsdVersion
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $ddpXsdVersion;
    /**
     * Constructor method for createResponse
     * @uses CreateResponse::setCreateErrors()
     * @uses CreateResponse::setCreateSuccess()
     * @uses CreateResponse::setDdpXsdVersion()
     * @param \Models\Docdata\StructType\CreateErrors $createErrors
     * @param \Models\Docdata\StructType\CreateSuccess $createSuccess
     * @param string $ddpXsdVersion
     */
    public function __construct(\Models\Docdata\StructType\CreateErrors $createErrors = null, \Models\Docdata\StructType\CreateSuccess $createSuccess = null, $ddpXsdVersion = null)
    {
        $this
            ->setCreateErrors($createErrors)
            ->setCreateSuccess($createSuccess)
            ->setDdpXsdVersion($ddpXsdVersion);
    }
    /**
     * Get createErrors value
     * @return \Models\Docdata\StructType\CreateErrors
     */
    public function getCreateErrors()
    {
        return $this->createErrors;
    }
    /**
     * Set createErrors value
     * @param \Models\Docdata\StructType\CreateErrors $createErrors
     * @return \Models\Docdata\StructType\CreateResponse
     */
    public function setCreateErrors(\Models\Docdata\StructType\CreateErrors $createErrors = null)
    {
        $this->createErrors = $createErrors;
        return $this;
    }
    /**
     * Get createSuccess value
     * @return \Models\Docdata\StructType\CreateSuccess
     */
    public function getCreateSuccess()
    {
        return $this->createSuccess;
    }
    /**
     * Set createSuccess value
     * @param \Models\Docdata\StructType\CreateSuccess $createSuccess
     * @return \Models\Docdata\StructType\CreateResponse
     */
    public function setCreateSuccess(\Models\Docdata\StructType\CreateSuccess $createSuccess = null)
    {
        $this->createSuccess = $createSuccess;
        return $this;
    }
    /**
     * Get ddpXsdVersion value
     * @return string
     */
    public function getDdpXsdVersion()
    {
        return $this->ddpXsdVersion;
    }
    /**
     * Set ddpXsdVersion value
     * @param string $ddpXsdVersion
     * @return \Models\Docdata\StructType\CreateResponse
     */
    public function setDdpXsdVersion($ddpXsdVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) > 35) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($ddpXsdVersion) ? strlen($ddpXsdVersion) : count($ddpXsdVersion)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ddpXsdVersion) && strlen($ddpXsdVersion) < 1) || (is_array($ddpXsdVersion) && count($ddpXsdVersion) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ddpXsdVersion) && !is_string($ddpXsdVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ddpXsdVersion)), __LINE__);
        }
        $this->ddpXsdVersion = $ddpXsdVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\CreateResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
