<?php

namespace Models\Docdata\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The street
     * Meta informations extracted from the WSDL
     * - documentation: Address lines must be filled as specific as possible using the house number and optionally the house number addition field.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $street;
    /**
     * The houseNumber
     * Meta informations extracted from the WSDL
     * - documentation: The house number.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $houseNumber;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $city;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Models\Docdata\StructType\Country
     */
    public $country;
    /**
     * The company
     * Meta informations extracted from the WSDL
     * - documentation: The name of the company.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $company;
    /**
     * The kvkNummer
     * Meta informations extracted from the WSDL
     * - documentation: Chamber of commerce number. In the Netherlands KvK number is mandatory for a company. Other countries this is an optional feature. This field is for future usage.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $kvkNummer;
    /**
     * The vatNumber
     * Meta informations extracted from the WSDL
     * - documentation: The European Union value added tax (EU VAT) is a value added tax encompassing member states in the European Union VAT area. Joining in this is compulsory for member states of the European Union. As consumption tax, the EU VAT taxes
     * the consumption of goods and services in the EU VAT area. The EU VAT's key issue asks where the supply and consumption occurs thereby determining which member state will collect the VAT and which VAT rate will be charged. This field is for future
     * usage.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $vatNumber;
    /**
     * The careOf
     * Meta informations extracted from the WSDL
     * - documentation: Care of, usually abbreviated as c/o on envelopes, signifies an intermediary who is responsible for transferring a piece of mail between the postal system and the final addressee. For example, when the addressee has no standard
     * address, is under a corporate mail system, or is being manually forwarded mail sent to a more accessible location. In Australia and New Zealand c/- is often used in place of c/o. This field is for future usage.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $careOf;
    /**
     * The houseNumberAddition
     * Meta informations extracted from the WSDL
     * - documentation: The addition to the house number.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $houseNumberAddition;
    /**
     * The postalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $postalCode;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - documentation: A state or province. Is mandatory for Argentina, Brazil, Canada, China, Indonesia, India, Japan, Mexico, Thailand and the US of A. when PayPal is used as payment method.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $state;
    /**
     * Constructor method for address
     * @uses Address::setStreet()
     * @uses Address::setHouseNumber()
     * @uses Address::setCity()
     * @uses Address::setCountry()
     * @uses Address::setCompany()
     * @uses Address::setKvkNummer()
     * @uses Address::setVatNumber()
     * @uses Address::setCareOf()
     * @uses Address::setHouseNumberAddition()
     * @uses Address::setPostalCode()
     * @uses Address::setState()
     * @param string $street
     * @param string $houseNumber
     * @param string $city
     * @param \Models\Docdata\StructType\Country $country
     * @param string $company
     * @param string $kvkNummer
     * @param string $vatNumber
     * @param string $careOf
     * @param string $houseNumberAddition
     * @param string $postalCode
     * @param string $state
     */
    public function __construct($street = null, $houseNumber = null, $city = null, \Models\Docdata\StructType\Country $country = null, $company = null, $kvkNummer = null, $vatNumber = null, $careOf = null, $houseNumberAddition = null, $postalCode = null, $state = null)
    {
        $this
            ->setStreet($street)
            ->setHouseNumber($houseNumber)
            ->setCity($city)
            ->setCountry($country)
            ->setCompany($company)
            ->setKvkNummer($kvkNummer)
            ->setVatNumber($vatNumber)
            ->setCareOf($careOf)
            ->setHouseNumberAddition($houseNumberAddition)
            ->setPostalCode($postalCode)
            ->setState($state);
    }
    /**
     * Get street value
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \Models\Docdata\StructType\Address
     */
    public function setStreet($street = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($street) && strlen($street) > 100) || (is_array($street) && count($street) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($street) ? strlen($street) : count($street)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($street) && strlen($street) < 1) || (is_array($street) && count($street) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return \Models\Docdata\StructType\Address
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($houseNumber) && strlen($houseNumber) > 35) || (is_array($houseNumber) && count($houseNumber) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($houseNumber) ? strlen($houseNumber) : count($houseNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($houseNumber) && strlen($houseNumber) < 1) || (is_array($houseNumber) && count($houseNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \Models\Docdata\StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($city) && strlen($city) > 35) || (is_array($city) && count($city) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($city) ? strlen($city) : count($city)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($city) && strlen($city) < 1) || (is_array($city) && count($city) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get country value
     * @return \Models\Docdata\StructType\Country
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param \Models\Docdata\StructType\Country $country
     * @return \Models\Docdata\StructType\Address
     */
    public function setCountry(\Models\Docdata\StructType\Country $country = null)
    {
        $this->country = $country;
        return $this;
    }
    /**
     * Get company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param string $company
     * @return \Models\Docdata\StructType\Address
     */
    public function setCompany($company = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($company) && strlen($company) > 35) || (is_array($company) && count($company) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($company) ? strlen($company) : count($company)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($company) && strlen($company) < 1) || (is_array($company) && count($company) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company)), __LINE__);
        }
        $this->company = $company;
        return $this;
    }
    /**
     * Get kvkNummer value
     * @return string|null
     */
    public function getKvkNummer()
    {
        return $this->kvkNummer;
    }
    /**
     * Set kvkNummer value
     * @param string $kvkNummer
     * @return \Models\Docdata\StructType\Address
     */
    public function setKvkNummer($kvkNummer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kvkNummer) && strlen($kvkNummer) > 35) || (is_array($kvkNummer) && count($kvkNummer) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($kvkNummer) ? strlen($kvkNummer) : count($kvkNummer)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($kvkNummer) && strlen($kvkNummer) < 1) || (is_array($kvkNummer) && count($kvkNummer) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kvkNummer) && !is_string($kvkNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kvkNummer)), __LINE__);
        }
        $this->kvkNummer = $kvkNummer;
        return $this;
    }
    /**
     * Get vatNumber value
     * @return string|null
     */
    public function getVatNumber()
    {
        return $this->vatNumber;
    }
    /**
     * Set vatNumber value
     * @param string $vatNumber
     * @return \Models\Docdata\StructType\Address
     */
    public function setVatNumber($vatNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vatNumber) && strlen($vatNumber) > 35) || (is_array($vatNumber) && count($vatNumber) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($vatNumber) ? strlen($vatNumber) : count($vatNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($vatNumber) && strlen($vatNumber) < 1) || (is_array($vatNumber) && count($vatNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vatNumber) && !is_string($vatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vatNumber)), __LINE__);
        }
        $this->vatNumber = $vatNumber;
        return $this;
    }
    /**
     * Get careOf value
     * @return string|null
     */
    public function getCareOf()
    {
        return $this->careOf;
    }
    /**
     * Set careOf value
     * @param string $careOf
     * @return \Models\Docdata\StructType\Address
     */
    public function setCareOf($careOf = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($careOf) && strlen($careOf) > 35) || (is_array($careOf) && count($careOf) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($careOf) ? strlen($careOf) : count($careOf)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($careOf) && strlen($careOf) < 1) || (is_array($careOf) && count($careOf) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($careOf) && !is_string($careOf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($careOf)), __LINE__);
        }
        $this->careOf = $careOf;
        return $this;
    }
    /**
     * Get houseNumberAddition value
     * @return string|null
     */
    public function getHouseNumberAddition()
    {
        return $this->houseNumberAddition;
    }
    /**
     * Set houseNumberAddition value
     * @param string $houseNumberAddition
     * @return \Models\Docdata\StructType\Address
     */
    public function setHouseNumberAddition($houseNumberAddition = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($houseNumberAddition) && strlen($houseNumberAddition) > 35) || (is_array($houseNumberAddition) && count($houseNumberAddition) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($houseNumberAddition) ? strlen($houseNumberAddition) : count($houseNumberAddition)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($houseNumberAddition) && strlen($houseNumberAddition) < 1) || (is_array($houseNumberAddition) && count($houseNumberAddition) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($houseNumberAddition) && !is_string($houseNumberAddition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($houseNumberAddition)), __LINE__);
        }
        $this->houseNumberAddition = $houseNumberAddition;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \Models\Docdata\StructType\Address
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postalCode) && strlen($postalCode) > 50) || (is_array($postalCode) && count($postalCode) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($postalCode) ? strlen($postalCode) : count($postalCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($postalCode) && strlen($postalCode) < 1) || (is_array($postalCode) && count($postalCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \Models\Docdata\StructType\Address
     */
    public function setState($state = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($state) && strlen($state) > 35) || (is_array($state) && count($state) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($state) ? strlen($state) : count($state)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($state) && strlen($state) < 1) || (is_array($state) && count($state) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Models\Docdata\StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
