<?php

namespace Models\Docdata\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceType
 * @subpackage Services
 */
class _List extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named listPaymentMethods
     * Meta informations extracted from the WSDL
     * - documentation: Lists all the possible the payment methods that are available for the given payment order key.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Models\Docdata\StructType\ListPaymentMethodsRequest $parameters
     * @return \Models\Docdata\StructType\ListPaymentMethodsResponse|bool
     */
    public function listPaymentMethods(\Models\Docdata\StructType\ListPaymentMethodsRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->listPaymentMethods($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Models\Docdata\StructType\ListPaymentMethodsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
