<?php

namespace Models\Docdata\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Start ServiceType
 * @subpackage Services
 */
class Start extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named start
     * Meta informations extracted from the WSDL
     * - documentation: Starts processing of a payment order in the DocData system. This is an alternative to using the web menu hosted payment pages. When an initial (previous) payment order is specified, the details will be reused from that payment order.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Models\Docdata\StructType\StartRequest $parameters
     * @return \Models\Docdata\StructType\StartResponse|bool
     */
    public function start(\Models\Docdata\StructType\StartRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->start($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Models\Docdata\StructType\StartResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
