<?php

namespace Liberty\Services\Emisor\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Emitir ServiceType
 * @subpackage Services
 */
class Emitir extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named emitir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Liberty\Services\Emisor\StructType\Emitir $parameters
     * @return \Liberty\Services\Emisor\StructType\EmitirResponse|bool
     */
    public function emitir(\Liberty\Services\Emisor\StructType\Emitir $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->emitir($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Liberty\Services\Emisor\StructType\EmitirResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
