<?php

namespace Liberty\Services\Emisor\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for alternativa StructType
 * @subpackage Structs
 */
class Alternativa extends AbstractStructBase
{
    /**
     * The codigoPlan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigoPlan;
    /**
     * The codigoProducto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigoProducto;
    /**
     * The deducible
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $deducible;
    /**
     * The montoPrimaBruta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $montoPrimaBruta;
    /**
     * The montoPrimaNeta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $montoPrimaNeta;
    /**
     * The numeroCotizacion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numeroCotizacion;
    /**
     * Constructor method for alternativa
     * @uses Alternativa::setCodigoPlan()
     * @uses Alternativa::setCodigoProducto()
     * @uses Alternativa::setDeducible()
     * @uses Alternativa::setMontoPrimaBruta()
     * @uses Alternativa::setMontoPrimaNeta()
     * @uses Alternativa::setNumeroCotizacion()
     * @param int $codigoPlan
     * @param int $codigoProducto
     * @param int $deducible
     * @param float $montoPrimaBruta
     * @param float $montoPrimaNeta
     * @param int $numeroCotizacion
     */
    public function __construct($codigoPlan = null, $codigoProducto = null, $deducible = null, $montoPrimaBruta = null, $montoPrimaNeta = null, $numeroCotizacion = null)
    {
        $this
            ->setCodigoPlan($codigoPlan)
            ->setCodigoProducto($codigoProducto)
            ->setDeducible($deducible)
            ->setMontoPrimaBruta($montoPrimaBruta)
            ->setMontoPrimaNeta($montoPrimaNeta)
            ->setNumeroCotizacion($numeroCotizacion);
    }
    /**
     * Get codigoPlan value
     * @return int|null
     */
    public function getCodigoPlan()
    {
        return $this->codigoPlan;
    }
    /**
     * Set codigoPlan value
     * @param int $codigoPlan
     * @return \Liberty\Services\Emisor\StructType\Alternativa
     */
    public function setCodigoPlan($codigoPlan = null)
    {
        // validation for constraint: int
        if (!is_null($codigoPlan) && !(is_int($codigoPlan) || ctype_digit($codigoPlan))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoPlan, true), gettype($codigoPlan)), __LINE__);
        }
        $this->codigoPlan = $codigoPlan;
        return $this;
    }
    /**
     * Get codigoProducto value
     * @return int|null
     */
    public function getCodigoProducto()
    {
        return $this->codigoProducto;
    }
    /**
     * Set codigoProducto value
     * @param int $codigoProducto
     * @return \Liberty\Services\Emisor\StructType\Alternativa
     */
    public function setCodigoProducto($codigoProducto = null)
    {
        // validation for constraint: int
        if (!is_null($codigoProducto) && !(is_int($codigoProducto) || ctype_digit($codigoProducto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoProducto, true), gettype($codigoProducto)), __LINE__);
        }
        $this->codigoProducto = $codigoProducto;
        return $this;
    }
    /**
     * Get deducible value
     * @return int|null
     */
    public function getDeducible()
    {
        return $this->deducible;
    }
    /**
     * Set deducible value
     * @param int $deducible
     * @return \Liberty\Services\Emisor\StructType\Alternativa
     */
    public function setDeducible($deducible = null)
    {
        // validation for constraint: int
        if (!is_null($deducible) && !(is_int($deducible) || ctype_digit($deducible))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deducible, true), gettype($deducible)), __LINE__);
        }
        $this->deducible = $deducible;
        return $this;
    }
    /**
     * Get montoPrimaBruta value
     * @return float|null
     */
    public function getMontoPrimaBruta()
    {
        return $this->montoPrimaBruta;
    }
    /**
     * Set montoPrimaBruta value
     * @param float $montoPrimaBruta
     * @return \Liberty\Services\Emisor\StructType\Alternativa
     */
    public function setMontoPrimaBruta($montoPrimaBruta = null)
    {
        // validation for constraint: float
        if (!is_null($montoPrimaBruta) && !(is_float($montoPrimaBruta) || is_numeric($montoPrimaBruta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoPrimaBruta, true), gettype($montoPrimaBruta)), __LINE__);
        }
        $this->montoPrimaBruta = $montoPrimaBruta;
        return $this;
    }
    /**
     * Get montoPrimaNeta value
     * @return float|null
     */
    public function getMontoPrimaNeta()
    {
        return $this->montoPrimaNeta;
    }
    /**
     * Set montoPrimaNeta value
     * @param float $montoPrimaNeta
     * @return \Liberty\Services\Emisor\StructType\Alternativa
     */
    public function setMontoPrimaNeta($montoPrimaNeta = null)
    {
        // validation for constraint: float
        if (!is_null($montoPrimaNeta) && !(is_float($montoPrimaNeta) || is_numeric($montoPrimaNeta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoPrimaNeta, true), gettype($montoPrimaNeta)), __LINE__);
        }
        $this->montoPrimaNeta = $montoPrimaNeta;
        return $this;
    }
    /**
     * Get numeroCotizacion value
     * @return int|null
     */
    public function getNumeroCotizacion()
    {
        return $this->numeroCotizacion;
    }
    /**
     * Set numeroCotizacion value
     * @param int $numeroCotizacion
     * @return \Liberty\Services\Emisor\StructType\Alternativa
     */
    public function setNumeroCotizacion($numeroCotizacion = null)
    {
        // validation for constraint: int
        if (!is_null($numeroCotizacion) && !(is_int($numeroCotizacion) || ctype_digit($numeroCotizacion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroCotizacion, true), gettype($numeroCotizacion)), __LINE__);
        }
        $this->numeroCotizacion = $numeroCotizacion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Liberty\Services\Emisor\StructType\Alternativa
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
