<?php

namespace Liberty\Services\Emisor\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for planPago StructType
 * @subpackage Structs
 */
class PlanPago extends AbstractStructBase
{
    /**
     * The avisoVencimiento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Liberty\Services\Emisor\StructType\AvisoVencimiento
     */
    public $avisoVencimiento;
    /**
     * The cuponera
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Liberty\Services\Emisor\StructType\Cuponera
     */
    public $cuponera;
    /**
     * The formaPago
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $formaPago;
    /**
     * The pac
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Liberty\Services\Emisor\StructType\CuentaCorrientePac
     */
    public $pac;
    /**
     * The pat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Liberty\Services\Emisor\StructType\TarjetaCreditoPat
     */
    public $pat;
    /**
     * Constructor method for planPago
     * @uses PlanPago::setAvisoVencimiento()
     * @uses PlanPago::setCuponera()
     * @uses PlanPago::setFormaPago()
     * @uses PlanPago::setPac()
     * @uses PlanPago::setPat()
     * @param \Liberty\Services\Emisor\StructType\AvisoVencimiento $avisoVencimiento
     * @param \Liberty\Services\Emisor\StructType\Cuponera $cuponera
     * @param int $formaPago
     * @param \Liberty\Services\Emisor\StructType\CuentaCorrientePac $pac
     * @param \Liberty\Services\Emisor\StructType\TarjetaCreditoPat $pat
     */
    public function __construct(\Liberty\Services\Emisor\StructType\AvisoVencimiento $avisoVencimiento = null, \Liberty\Services\Emisor\StructType\Cuponera $cuponera = null, $formaPago = null, \Liberty\Services\Emisor\StructType\CuentaCorrientePac $pac = null, \Liberty\Services\Emisor\StructType\TarjetaCreditoPat $pat = null)
    {
        $this
            ->setAvisoVencimiento($avisoVencimiento)
            ->setCuponera($cuponera)
            ->setFormaPago($formaPago)
            ->setPac($pac)
            ->setPat($pat);
    }
    /**
     * Get avisoVencimiento value
     * @return \Liberty\Services\Emisor\StructType\AvisoVencimiento|null
     */
    public function getAvisoVencimiento()
    {
        return $this->avisoVencimiento;
    }
    /**
     * Set avisoVencimiento value
     * @param \Liberty\Services\Emisor\StructType\AvisoVencimiento $avisoVencimiento
     * @return \Liberty\Services\Emisor\StructType\PlanPago
     */
    public function setAvisoVencimiento(\Liberty\Services\Emisor\StructType\AvisoVencimiento $avisoVencimiento = null)
    {
        $this->avisoVencimiento = $avisoVencimiento;
        return $this;
    }
    /**
     * Get cuponera value
     * @return \Liberty\Services\Emisor\StructType\Cuponera|null
     */
    public function getCuponera()
    {
        return $this->cuponera;
    }
    /**
     * Set cuponera value
     * @param \Liberty\Services\Emisor\StructType\Cuponera $cuponera
     * @return \Liberty\Services\Emisor\StructType\PlanPago
     */
    public function setCuponera(\Liberty\Services\Emisor\StructType\Cuponera $cuponera = null)
    {
        $this->cuponera = $cuponera;
        return $this;
    }
    /**
     * Get formaPago value
     * @return int|null
     */
    public function getFormaPago()
    {
        return $this->formaPago;
    }
    /**
     * Set formaPago value
     * @param int $formaPago
     * @return \Liberty\Services\Emisor\StructType\PlanPago
     */
    public function setFormaPago($formaPago = null)
    {
        // validation for constraint: int
        if (!is_null($formaPago) && !(is_int($formaPago) || ctype_digit($formaPago))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($formaPago, true), gettype($formaPago)), __LINE__);
        }
        $this->formaPago = $formaPago;
        return $this;
    }
    /**
     * Get pac value
     * @return \Liberty\Services\Emisor\StructType\CuentaCorrientePac|null
     */
    public function getPac()
    {
        return $this->pac;
    }
    /**
     * Set pac value
     * @param \Liberty\Services\Emisor\StructType\CuentaCorrientePac $pac
     * @return \Liberty\Services\Emisor\StructType\PlanPago
     */
    public function setPac(\Liberty\Services\Emisor\StructType\CuentaCorrientePac $pac = null)
    {
        $this->pac = $pac;
        return $this;
    }
    /**
     * Get pat value
     * @return \Liberty\Services\Emisor\StructType\TarjetaCreditoPat|null
     */
    public function getPat()
    {
        return $this->pat;
    }
    /**
     * Set pat value
     * @param \Liberty\Services\Emisor\StructType\TarjetaCreditoPat $pat
     * @return \Liberty\Services\Emisor\StructType\PlanPago
     */
    public function setPat(\Liberty\Services\Emisor\StructType\TarjetaCreditoPat $pat = null)
    {
        $this->pat = $pat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Liberty\Services\Emisor\StructType\PlanPago
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
