<?php

namespace Liberty\Services\Emisor\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for inspeccion StructType
 * @subpackage Structs
 */
class Inspeccion extends AbstractStructBase
{
    /**
     * The celularContacto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $celularContacto;
    /**
     * The correoContacto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $correoContacto;
    /**
     * The nombreContacto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nombreContacto;
    /**
     * The rutContacto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $rutContacto;
    /**
     * The rutDvContacto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rutDvContacto;
    /**
     * The telefonoContacto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telefonoContacto;
    /**
     * Constructor method for inspeccion
     * @uses Inspeccion::setCelularContacto()
     * @uses Inspeccion::setCorreoContacto()
     * @uses Inspeccion::setNombreContacto()
     * @uses Inspeccion::setRutContacto()
     * @uses Inspeccion::setRutDvContacto()
     * @uses Inspeccion::setTelefonoContacto()
     * @param string $celularContacto
     * @param string $correoContacto
     * @param string $nombreContacto
     * @param int $rutContacto
     * @param string $rutDvContacto
     * @param string $telefonoContacto
     */
    public function __construct($celularContacto = null, $correoContacto = null, $nombreContacto = null, $rutContacto = null, $rutDvContacto = null, $telefonoContacto = null)
    {
        $this
            ->setCelularContacto($celularContacto)
            ->setCorreoContacto($correoContacto)
            ->setNombreContacto($nombreContacto)
            ->setRutContacto($rutContacto)
            ->setRutDvContacto($rutDvContacto)
            ->setTelefonoContacto($telefonoContacto);
    }
    /**
     * Get celularContacto value
     * @return string|null
     */
    public function getCelularContacto()
    {
        return $this->celularContacto;
    }
    /**
     * Set celularContacto value
     * @param string $celularContacto
     * @return \Liberty\Services\Emisor\StructType\Inspeccion
     */
    public function setCelularContacto($celularContacto = null)
    {
        // validation for constraint: string
        if (!is_null($celularContacto) && !is_string($celularContacto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($celularContacto, true), gettype($celularContacto)), __LINE__);
        }
        $this->celularContacto = $celularContacto;
        return $this;
    }
    /**
     * Get correoContacto value
     * @return string|null
     */
    public function getCorreoContacto()
    {
        return $this->correoContacto;
    }
    /**
     * Set correoContacto value
     * @param string $correoContacto
     * @return \Liberty\Services\Emisor\StructType\Inspeccion
     */
    public function setCorreoContacto($correoContacto = null)
    {
        // validation for constraint: string
        if (!is_null($correoContacto) && !is_string($correoContacto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correoContacto, true), gettype($correoContacto)), __LINE__);
        }
        $this->correoContacto = $correoContacto;
        return $this;
    }
    /**
     * Get nombreContacto value
     * @return string|null
     */
    public function getNombreContacto()
    {
        return $this->nombreContacto;
    }
    /**
     * Set nombreContacto value
     * @param string $nombreContacto
     * @return \Liberty\Services\Emisor\StructType\Inspeccion
     */
    public function setNombreContacto($nombreContacto = null)
    {
        // validation for constraint: string
        if (!is_null($nombreContacto) && !is_string($nombreContacto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombreContacto, true), gettype($nombreContacto)), __LINE__);
        }
        $this->nombreContacto = $nombreContacto;
        return $this;
    }
    /**
     * Get rutContacto value
     * @return int|null
     */
    public function getRutContacto()
    {
        return $this->rutContacto;
    }
    /**
     * Set rutContacto value
     * @param int $rutContacto
     * @return \Liberty\Services\Emisor\StructType\Inspeccion
     */
    public function setRutContacto($rutContacto = null)
    {
        // validation for constraint: int
        if (!is_null($rutContacto) && !(is_int($rutContacto) || ctype_digit($rutContacto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rutContacto, true), gettype($rutContacto)), __LINE__);
        }
        $this->rutContacto = $rutContacto;
        return $this;
    }
    /**
     * Get rutDvContacto value
     * @return string|null
     */
    public function getRutDvContacto()
    {
        return $this->rutDvContacto;
    }
    /**
     * Set rutDvContacto value
     * @param string $rutDvContacto
     * @return \Liberty\Services\Emisor\StructType\Inspeccion
     */
    public function setRutDvContacto($rutDvContacto = null)
    {
        // validation for constraint: string
        if (!is_null($rutDvContacto) && !is_string($rutDvContacto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rutDvContacto, true), gettype($rutDvContacto)), __LINE__);
        }
        $this->rutDvContacto = $rutDvContacto;
        return $this;
    }
    /**
     * Get telefonoContacto value
     * @return string|null
     */
    public function getTelefonoContacto()
    {
        return $this->telefonoContacto;
    }
    /**
     * Set telefonoContacto value
     * @param string $telefonoContacto
     * @return \Liberty\Services\Emisor\StructType\Inspeccion
     */
    public function setTelefonoContacto($telefonoContacto = null)
    {
        // validation for constraint: string
        if (!is_null($telefonoContacto) && !is_string($telefonoContacto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefonoContacto, true), gettype($telefonoContacto)), __LINE__);
        }
        $this->telefonoContacto = $telefonoContacto;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Liberty\Services\Emisor\StructType\Inspeccion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
