<?php

namespace Liberty\Services\Emisor\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for opcionales StructType
 * @subpackage Structs
 */
class Opcionales extends AbstractStructBase
{
    /**
     * The entry
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Liberty\Services\Emisor\StructType\Entry[]
     */
    public $entry;
    /**
     * Constructor method for opcionales
     * @uses Opcionales::setEntry()
     * @param \Liberty\Services\Emisor\StructType\Entry[] $entry
     */
    public function __construct(array $entry = array())
    {
        $this
            ->setEntry($entry);
    }
    /**
     * Get entry value
     * @return \Liberty\Services\Emisor\StructType\Entry[]|null
     */
    public function getEntry()
    {
        return $this->entry;
    }
    /**
     * This method is responsible for validating the values passed to the setEntry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEntry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEntryForArrayConstraintsFromSetEntry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $opcionalesEntryItem) {
            // validation for constraint: itemType
            if (!$opcionalesEntryItem instanceof \Liberty\Services\Emisor\StructType\Entry) {
                $invalidValues[] = is_object($opcionalesEntryItem) ? get_class($opcionalesEntryItem) : sprintf('%s(%s)', gettype($opcionalesEntryItem), var_export($opcionalesEntryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The entry property can only contain items of type \Liberty\Services\Emisor\StructType\Entry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set entry value
     * @throws \InvalidArgumentException
     * @param \Liberty\Services\Emisor\StructType\Entry[] $entry
     * @return \Liberty\Services\Emisor\StructType\Opcionales
     */
    public function setEntry(array $entry = array())
    {
        // validation for constraint: array
        if ('' !== ($entryArrayErrorMessage = self::validateEntryForArrayConstraintsFromSetEntry($entry))) {
            throw new \InvalidArgumentException($entryArrayErrorMessage, __LINE__);
        }
        $this->entry = $entry;
        return $this;
    }
    /**
     * Add item to entry value
     * @throws \InvalidArgumentException
     * @param \Liberty\Services\Emisor\StructType\Entry $item
     * @return \Liberty\Services\Emisor\StructType\Opcionales
     */
    public function addToEntry(\Liberty\Services\Emisor\StructType\Entry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Liberty\Services\Emisor\StructType\Entry) {
            throw new \InvalidArgumentException(sprintf('The entry property can only contain items of type \Liberty\Services\Emisor\StructType\Entry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->entry[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Liberty\Services\Emisor\StructType\Opcionales
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
