<?php

namespace Liberty\Services\Emisor\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for emisorResponse StructType
 * @subpackage Structs
 */
class EmisorResponse extends AbstractStructBase
{
    /**
     * The detalle
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Liberty\Services\Emisor\StructType\DetalleResponse[]
     */
    public $detalle;
    /**
     * The item
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $item;
    /**
     * The numeroCertificado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numeroCertificado;
    /**
     * The numeroPoliza
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numeroPoliza;
    /**
     * The status
     * @var bool
     */
    public $status;
    /**
     * Constructor method for emisorResponse
     * @uses EmisorResponse::setDetalle()
     * @uses EmisorResponse::setItem()
     * @uses EmisorResponse::setNumeroCertificado()
     * @uses EmisorResponse::setNumeroPoliza()
     * @uses EmisorResponse::setStatus()
     * @param \Liberty\Services\Emisor\StructType\DetalleResponse[] $detalle
     * @param int $item
     * @param int $numeroCertificado
     * @param int $numeroPoliza
     * @param bool $status
     */
    public function __construct(array $detalle = array(), $item = null, $numeroCertificado = null, $numeroPoliza = null, $status = null)
    {
        $this
            ->setDetalle($detalle)
            ->setItem($item)
            ->setNumeroCertificado($numeroCertificado)
            ->setNumeroPoliza($numeroPoliza)
            ->setStatus($status);
    }
    /**
     * Get detalle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Liberty\Services\Emisor\StructType\DetalleResponse[]|null
     */
    public function getDetalle()
    {
        return isset($this->detalle) ? $this->detalle : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDetalle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDetalle method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDetalleForArrayConstraintsFromSetDetalle(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $emisorResponseDetalleItem) {
            // validation for constraint: itemType
            if (!$emisorResponseDetalleItem instanceof \Liberty\Services\Emisor\StructType\DetalleResponse) {
                $invalidValues[] = is_object($emisorResponseDetalleItem) ? get_class($emisorResponseDetalleItem) : sprintf('%s(%s)', gettype($emisorResponseDetalleItem), var_export($emisorResponseDetalleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The detalle property can only contain items of type \Liberty\Services\Emisor\StructType\DetalleResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set detalle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Liberty\Services\Emisor\StructType\DetalleResponse[] $detalle
     * @return \Liberty\Services\Emisor\StructType\EmisorResponse
     */
    public function setDetalle(array $detalle = array())
    {
        // validation for constraint: array
        if ('' !== ($detalleArrayErrorMessage = self::validateDetalleForArrayConstraintsFromSetDetalle($detalle))) {
            throw new \InvalidArgumentException($detalleArrayErrorMessage, __LINE__);
        }
        if (is_null($detalle) || (is_array($detalle) && empty($detalle))) {
            unset($this->detalle);
        } else {
            $this->detalle = $detalle;
        }
        return $this;
    }
    /**
     * Add item to detalle value
     * @throws \InvalidArgumentException
     * @param \Liberty\Services\Emisor\StructType\DetalleResponse $item
     * @return \Liberty\Services\Emisor\StructType\EmisorResponse
     */
    public function addToDetalle(\Liberty\Services\Emisor\StructType\DetalleResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Liberty\Services\Emisor\StructType\DetalleResponse) {
            throw new \InvalidArgumentException(sprintf('The detalle property can only contain items of type \Liberty\Services\Emisor\StructType\DetalleResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->detalle[] = $item;
        return $this;
    }
    /**
     * Get item value
     * @return int|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param int $item
     * @return \Liberty\Services\Emisor\StructType\EmisorResponse
     */
    public function setItem($item = null)
    {
        // validation for constraint: int
        if (!is_null($item) && !(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($item, true), gettype($item)), __LINE__);
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Get numeroCertificado value
     * @return int|null
     */
    public function getNumeroCertificado()
    {
        return $this->numeroCertificado;
    }
    /**
     * Set numeroCertificado value
     * @param int $numeroCertificado
     * @return \Liberty\Services\Emisor\StructType\EmisorResponse
     */
    public function setNumeroCertificado($numeroCertificado = null)
    {
        // validation for constraint: int
        if (!is_null($numeroCertificado) && !(is_int($numeroCertificado) || ctype_digit($numeroCertificado))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroCertificado, true), gettype($numeroCertificado)), __LINE__);
        }
        $this->numeroCertificado = $numeroCertificado;
        return $this;
    }
    /**
     * Get numeroPoliza value
     * @return int|null
     */
    public function getNumeroPoliza()
    {
        return $this->numeroPoliza;
    }
    /**
     * Set numeroPoliza value
     * @param int $numeroPoliza
     * @return \Liberty\Services\Emisor\StructType\EmisorResponse
     */
    public function setNumeroPoliza($numeroPoliza = null)
    {
        // validation for constraint: int
        if (!is_null($numeroPoliza) && !(is_int($numeroPoliza) || ctype_digit($numeroPoliza))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroPoliza, true), gettype($numeroPoliza)), __LINE__);
        }
        $this->numeroPoliza = $numeroPoliza;
        return $this;
    }
    /**
     * Get status value
     * @return bool|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param bool $status
     * @return \Liberty\Services\Emisor\StructType\EmisorResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: boolean
        if (!is_null($status) && !is_bool($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Liberty\Services\Emisor\StructType\EmisorResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
