<?php

namespace Liberty\Services\Emisor\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for emisorRequest StructType
 * @subpackage Structs
 */
class EmisorRequest extends AbstractStructBase
{
    /**
     * The alternativaSeleccionada
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Liberty\Services\Emisor\StructType\Alternativa
     */
    public $alternativaSeleccionada;
    /**
     * The appKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $appKey;
    /**
     * The asegurado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Liberty\Services\Emisor\StructType\Asegurado_1
     */
    public $asegurado;
    /**
     * The conductores
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Liberty\Services\Emisor\StructType\Conductor[]
     */
    public $conductores;
    /**
     * The contratante
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Liberty\Services\Emisor\StructType\Contratante
     */
    public $contratante;
    /**
     * The fechaInicioVigencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fechaInicioVigencia;
    /**
     * The fechaTerminoVigencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fechaTerminoVigencia;
    /**
     * The opcionales
     * @var \Liberty\Services\Emisor\StructType\Opcionales_1
     */
    public $opcionales;
    /**
     * The planPago
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Liberty\Services\Emisor\StructType\PlanPago
     */
    public $planPago;
    /**
     * The riesgo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Liberty\Services\Emisor\StructType\Riesgo
     */
    public $riesgo;
    /**
     * The rutCorredor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $rutCorredor;
    /**
     * The sucursal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sucursal;
    /**
     * The tipoEmision
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Liberty\Services\Emisor\StructType\TipoEmision
     */
    public $tipoEmision;
    /**
     * The usuarioCorredor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usuarioCorredor;
    /**
     * Constructor method for emisorRequest
     * @uses EmisorRequest::setAlternativaSeleccionada()
     * @uses EmisorRequest::setAppKey()
     * @uses EmisorRequest::setAsegurado()
     * @uses EmisorRequest::setConductores()
     * @uses EmisorRequest::setContratante()
     * @uses EmisorRequest::setFechaInicioVigencia()
     * @uses EmisorRequest::setFechaTerminoVigencia()
     * @uses EmisorRequest::setOpcionales()
     * @uses EmisorRequest::setPlanPago()
     * @uses EmisorRequest::setRiesgo()
     * @uses EmisorRequest::setRutCorredor()
     * @uses EmisorRequest::setSucursal()
     * @uses EmisorRequest::setTipoEmision()
     * @uses EmisorRequest::setUsuarioCorredor()
     * @param \Liberty\Services\Emisor\StructType\Alternativa $alternativaSeleccionada
     * @param string $appKey
     * @param \Liberty\Services\Emisor\StructType\Asegurado_1 $asegurado
     * @param \Liberty\Services\Emisor\StructType\Conductor[] $conductores
     * @param \Liberty\Services\Emisor\StructType\Contratante $contratante
     * @param string $fechaInicioVigencia
     * @param string $fechaTerminoVigencia
     * @param \Liberty\Services\Emisor\StructType\Opcionales_1 $opcionales
     * @param \Liberty\Services\Emisor\StructType\PlanPago $planPago
     * @param \Liberty\Services\Emisor\StructType\Riesgo $riesgo
     * @param int $rutCorredor
     * @param string $sucursal
     * @param \Liberty\Services\Emisor\StructType\TipoEmision $tipoEmision
     * @param string $usuarioCorredor
     */
    public function __construct(\Liberty\Services\Emisor\StructType\Alternativa $alternativaSeleccionada = null, $appKey = null, \Liberty\Services\Emisor\StructType\Asegurado_1 $asegurado = null, array $conductores = array(), \Liberty\Services\Emisor\StructType\Contratante $contratante = null, $fechaInicioVigencia = null, $fechaTerminoVigencia = null, \Liberty\Services\Emisor\StructType\Opcionales_1 $opcionales = null, \Liberty\Services\Emisor\StructType\PlanPago $planPago = null, \Liberty\Services\Emisor\StructType\Riesgo $riesgo = null, $rutCorredor = null, $sucursal = null, \Liberty\Services\Emisor\StructType\TipoEmision $tipoEmision = null, $usuarioCorredor = null)
    {
        $this
            ->setAlternativaSeleccionada($alternativaSeleccionada)
            ->setAppKey($appKey)
            ->setAsegurado($asegurado)
            ->setConductores($conductores)
            ->setContratante($contratante)
            ->setFechaInicioVigencia($fechaInicioVigencia)
            ->setFechaTerminoVigencia($fechaTerminoVigencia)
            ->setOpcionales($opcionales)
            ->setPlanPago($planPago)
            ->setRiesgo($riesgo)
            ->setRutCorredor($rutCorredor)
            ->setSucursal($sucursal)
            ->setTipoEmision($tipoEmision)
            ->setUsuarioCorredor($usuarioCorredor);
    }
    /**
     * Get alternativaSeleccionada value
     * @return \Liberty\Services\Emisor\StructType\Alternativa|null
     */
    public function getAlternativaSeleccionada()
    {
        return $this->alternativaSeleccionada;
    }
    /**
     * Set alternativaSeleccionada value
     * @param \Liberty\Services\Emisor\StructType\Alternativa $alternativaSeleccionada
     * @return \Liberty\Services\Emisor\StructType\EmisorRequest
     */
    public function setAlternativaSeleccionada(\Liberty\Services\Emisor\StructType\Alternativa $alternativaSeleccionada = null)
    {
        $this->alternativaSeleccionada = $alternativaSeleccionada;
        return $this;
    }
    /**
     * Get appKey value
     * @return string|null
     */
    public function getAppKey()
    {
        return $this->appKey;
    }
    /**
     * Set appKey value
     * @param string $appKey
     * @return \Liberty\Services\Emisor\StructType\EmisorRequest
     */
    public function setAppKey($appKey = null)
    {
        // validation for constraint: string
        if (!is_null($appKey) && !is_string($appKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appKey)), __LINE__);
        }
        $this->appKey = $appKey;
        return $this;
    }
    /**
     * Get asegurado value
     * @return \Liberty\Services\Emisor\StructType\Asegurado_1|null
     */
    public function getAsegurado()
    {
        return $this->asegurado;
    }
    /**
     * Set asegurado value
     * @param \Liberty\Services\Emisor\StructType\Asegurado_1 $asegurado
     * @return \Liberty\Services\Emisor\StructType\EmisorRequest
     */
    public function setAsegurado(\Liberty\Services\Emisor\StructType\Asegurado_1 $asegurado = null)
    {
        $this->asegurado = $asegurado;
        return $this;
    }
    /**
     * Get conductores value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Liberty\Services\Emisor\StructType\Conductor[]|null
     */
    public function getConductores()
    {
        return isset($this->conductores) ? $this->conductores : null;
    }
    /**
     * Set conductores value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Liberty\Services\Emisor\StructType\Conductor[] $conductores
     * @return \Liberty\Services\Emisor\StructType\EmisorRequest
     */
    public function setConductores(array $conductores = array())
    {
        foreach ($conductores as $emisorRequestConductoresItem) {
            // validation for constraint: itemType
            if (!$emisorRequestConductoresItem instanceof \Liberty\Services\Emisor\StructType\Conductor) {
                throw new \InvalidArgumentException(sprintf('The conductores property can only contain items of \Liberty\Services\Emisor\StructType\Conductor, "%s" given', is_object($emisorRequestConductoresItem) ? get_class($emisorRequestConductoresItem) : gettype($emisorRequestConductoresItem)), __LINE__);
            }
        }
        if (is_null($conductores) || (is_array($conductores) && empty($conductores))) {
            unset($this->conductores);
        } else {
            $this->conductores = $conductores;
        }
        return $this;
    }
    /**
     * Add item to conductores value
     * @throws \InvalidArgumentException
     * @param \Liberty\Services\Emisor\StructType\Conductor $item
     * @return \Liberty\Services\Emisor\StructType\EmisorRequest
     */
    public function addToConductores(\Liberty\Services\Emisor\StructType\Conductor $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Liberty\Services\Emisor\StructType\Conductor) {
            throw new \InvalidArgumentException(sprintf('The conductores property can only contain items of \Liberty\Services\Emisor\StructType\Conductor, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->conductores[] = $item;
        return $this;
    }
    /**
     * Get contratante value
     * @return \Liberty\Services\Emisor\StructType\Contratante|null
     */
    public function getContratante()
    {
        return $this->contratante;
    }
    /**
     * Set contratante value
     * @param \Liberty\Services\Emisor\StructType\Contratante $contratante
     * @return \Liberty\Services\Emisor\StructType\EmisorRequest
     */
    public function setContratante(\Liberty\Services\Emisor\StructType\Contratante $contratante = null)
    {
        $this->contratante = $contratante;
        return $this;
    }
    /**
     * Get fechaInicioVigencia value
     * @return string|null
     */
    public function getFechaInicioVigencia()
    {
        return $this->fechaInicioVigencia;
    }
    /**
     * Set fechaInicioVigencia value
     * @param string $fechaInicioVigencia
     * @return \Liberty\Services\Emisor\StructType\EmisorRequest
     */
    public function setFechaInicioVigencia($fechaInicioVigencia = null)
    {
        // validation for constraint: string
        if (!is_null($fechaInicioVigencia) && !is_string($fechaInicioVigencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaInicioVigencia)), __LINE__);
        }
        $this->fechaInicioVigencia = $fechaInicioVigencia;
        return $this;
    }
    /**
     * Get fechaTerminoVigencia value
     * @return string|null
     */
    public function getFechaTerminoVigencia()
    {
        return $this->fechaTerminoVigencia;
    }
    /**
     * Set fechaTerminoVigencia value
     * @param string $fechaTerminoVigencia
     * @return \Liberty\Services\Emisor\StructType\EmisorRequest
     */
    public function setFechaTerminoVigencia($fechaTerminoVigencia = null)
    {
        // validation for constraint: string
        if (!is_null($fechaTerminoVigencia) && !is_string($fechaTerminoVigencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaTerminoVigencia)), __LINE__);
        }
        $this->fechaTerminoVigencia = $fechaTerminoVigencia;
        return $this;
    }
    /**
     * Get opcionales value
     * @return \Liberty\Services\Emisor\StructType\Opcionales_1|null
     */
    public function getOpcionales()
    {
        return $this->opcionales;
    }
    /**
     * Set opcionales value
     * @param \Liberty\Services\Emisor\StructType\Opcionales_1 $opcionales
     * @return \Liberty\Services\Emisor\StructType\EmisorRequest
     */
    public function setOpcionales(\Liberty\Services\Emisor\StructType\Opcionales_1 $opcionales = null)
    {
        $this->opcionales = $opcionales;
        return $this;
    }
    /**
     * Get planPago value
     * @return \Liberty\Services\Emisor\StructType\PlanPago|null
     */
    public function getPlanPago()
    {
        return $this->planPago;
    }
    /**
     * Set planPago value
     * @param \Liberty\Services\Emisor\StructType\PlanPago $planPago
     * @return \Liberty\Services\Emisor\StructType\EmisorRequest
     */
    public function setPlanPago(\Liberty\Services\Emisor\StructType\PlanPago $planPago = null)
    {
        $this->planPago = $planPago;
        return $this;
    }
    /**
     * Get riesgo value
     * @return \Liberty\Services\Emisor\StructType\Riesgo|null
     */
    public function getRiesgo()
    {
        return $this->riesgo;
    }
    /**
     * Set riesgo value
     * @param \Liberty\Services\Emisor\StructType\Riesgo $riesgo
     * @return \Liberty\Services\Emisor\StructType\EmisorRequest
     */
    public function setRiesgo(\Liberty\Services\Emisor\StructType\Riesgo $riesgo = null)
    {
        $this->riesgo = $riesgo;
        return $this;
    }
    /**
     * Get rutCorredor value
     * @return int|null
     */
    public function getRutCorredor()
    {
        return $this->rutCorredor;
    }
    /**
     * Set rutCorredor value
     * @param int $rutCorredor
     * @return \Liberty\Services\Emisor\StructType\EmisorRequest
     */
    public function setRutCorredor($rutCorredor = null)
    {
        // validation for constraint: int
        if (!is_null($rutCorredor) && !is_numeric($rutCorredor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rutCorredor)), __LINE__);
        }
        $this->rutCorredor = $rutCorredor;
        return $this;
    }
    /**
     * Get sucursal value
     * @return string|null
     */
    public function getSucursal()
    {
        return $this->sucursal;
    }
    /**
     * Set sucursal value
     * @param string $sucursal
     * @return \Liberty\Services\Emisor\StructType\EmisorRequest
     */
    public function setSucursal($sucursal = null)
    {
        // validation for constraint: string
        if (!is_null($sucursal) && !is_string($sucursal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sucursal)), __LINE__);
        }
        $this->sucursal = $sucursal;
        return $this;
    }
    /**
     * Get tipoEmision value
     * @return \Liberty\Services\Emisor\StructType\TipoEmision|null
     */
    public function getTipoEmision()
    {
        return $this->tipoEmision;
    }
    /**
     * Set tipoEmision value
     * @param \Liberty\Services\Emisor\StructType\TipoEmision $tipoEmision
     * @return \Liberty\Services\Emisor\StructType\EmisorRequest
     */
    public function setTipoEmision(\Liberty\Services\Emisor\StructType\TipoEmision $tipoEmision = null)
    {
        $this->tipoEmision = $tipoEmision;
        return $this;
    }
    /**
     * Get usuarioCorredor value
     * @return string|null
     */
    public function getUsuarioCorredor()
    {
        return $this->usuarioCorredor;
    }
    /**
     * Set usuarioCorredor value
     * @param string $usuarioCorredor
     * @return \Liberty\Services\Emisor\StructType\EmisorRequest
     */
    public function setUsuarioCorredor($usuarioCorredor = null)
    {
        // validation for constraint: string
        if (!is_null($usuarioCorredor) && !is_string($usuarioCorredor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usuarioCorredor)), __LINE__);
        }
        $this->usuarioCorredor = $usuarioCorredor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Liberty\Services\Emisor\StructType\EmisorRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
