<?php

namespace Liberty\Services\Emisor;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'emitir' => '\\Liberty\\Services\\Emisor\\StructType\\Emitir',
            'emisorRequest' => '\\Liberty\\Services\\Emisor\\StructType\\EmisorRequest',
            'opcionales' => '\\Liberty\\Services\\Emisor\\StructType\\Opcionales_1',
            'entry' => '\\Liberty\\Services\\Emisor\\StructType\\Entry',
            'alternativa' => '\\Liberty\\Services\\Emisor\\StructType\\Alternativa',
            'asegurado' => '\\Liberty\\Services\\Emisor\\StructType\\Asegurado_1',
            'conductor' => '\\Liberty\\Services\\Emisor\\StructType\\Conductor',
            'contratante' => '\\Liberty\\Services\\Emisor\\StructType\\Contratante',
            'planPago' => '\\Liberty\\Services\\Emisor\\StructType\\PlanPago',
            'avisoVencimiento' => '\\Liberty\\Services\\Emisor\\StructType\\AvisoVencimiento',
            'cuponera' => '\\Liberty\\Services\\Emisor\\StructType\\Cuponera',
            'cuentaCorrientePac' => '\\Liberty\\Services\\Emisor\\StructType\\CuentaCorrientePac',
            'tarjetaCreditoPat' => '\\Liberty\\Services\\Emisor\\StructType\\TarjetaCreditoPat',
            'riesgo' => '\\Liberty\\Services\\Emisor\\StructType\\Riesgo',
            'tipoEmision' => '\\Liberty\\Services\\Emisor\\StructType\\TipoEmision',
            'continuidad' => '\\Liberty\\Services\\Emisor\\StructType\\Continuidad',
            'factura' => '\\Liberty\\Services\\Emisor\\StructType\\Factura',
            'guia' => '\\Liberty\\Services\\Emisor\\StructType\\Guia',
            'inspeccion' => '\\Liberty\\Services\\Emisor\\StructType\\Inspeccion',
            'emitirResponse' => '\\Liberty\\Services\\Emisor\\StructType\\EmitirResponse',
            'emisorResponse' => '\\Liberty\\Services\\Emisor\\StructType\\EmisorResponse',
            'detalleResponse' => '\\Liberty\\Services\\Emisor\\StructType\\DetalleResponse',
            'Exception' => '\\Liberty\\Services\\Emisor\\StructType\\Exception',
        );
    }
}
