<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Make ServiceType
 */
$make = new \ServiceType\Make($options);
/**
 * Sample call for makeCallSoap operation/method
 */
if ($make->makeCallSoap(new \StructType\Credential(), $in1, new \StructType\UserProfile()) !== false) {
    print_r($make->getResult());
} else {
    print_r($make->getLastError());
}
/**
 * Samples for End ServiceType
 */
$end = new \ServiceType\End($options);
/**
 * Sample call for endCallSoap operation/method
 */
if ($end->endCallSoap(new \StructType\Credential(), new \StructType\UserProfile()) !== false) {
    print_r($end->getResult());
} else {
    print_r($end->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getProfileSoap operation/method
 */
if ($get->getProfileSoap(new \StructType\Credential(), $in1) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProfileDetailSoap operation/method
 */
if ($get->getProfileDetailSoap(new \StructType\Credential()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPrimaryLine operation/method
 */
if ($get->getPrimaryLine(new \StructType\Credential()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \ServiceType\Is($options);
/**
 * Sample call for isClusterUserSoap operation/method
 */
if ($is->isClusterUserSoap($in0) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
