<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CallResponse StructType
 * @subpackage Structs
 */
class CallResponse extends AbstractStructBase
{
    /**
     * The responseCode
     * @var int
     */
    public $responseCode;
    /**
     * The responseDescription
     * @var string
     */
    public $responseDescription;
    /**
     * Constructor method for CallResponse
     * @uses CallResponse::setResponseCode()
     * @uses CallResponse::setResponseDescription()
     * @param int $responseCode
     * @param string $responseDescription
     */
    public function __construct($responseCode = null, $responseDescription = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setResponseDescription($responseDescription);
    }
    /**
     * Get responseCode value
     * @return int|null
     */
    public function getResponseCode()
    {
        return $this->responseCode;
    }
    /**
     * Set responseCode value
     * @param int $responseCode
     * @return \StructType\CallResponse
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: int
        if (!is_null($responseCode) && !is_numeric($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($responseCode)), __LINE__);
        }
        $this->responseCode = $responseCode;
        return $this;
    }
    /**
     * Get responseDescription value
     * @return string|null
     */
    public function getResponseDescription()
    {
        return $this->responseDescription;
    }
    /**
     * Set responseDescription value
     * @param string $responseDescription
     * @return \StructType\CallResponse
     */
    public function setResponseDescription($responseDescription = null)
    {
        // validation for constraint: string
        if (!is_null($responseDescription) && !is_string($responseDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseDescription)), __LINE__);
        }
        $this->responseDescription = $responseDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CallResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
