<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WDDeviceInfoDetail StructType
 * @subpackage Structs
 */
class WDDeviceInfoDetail extends AbstractStructBase
{
    /**
     * The deviceName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $deviceName;
    /**
     * The lines
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - arrayType: soapenc:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $lines;
    /**
     * The phoneDesc
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $phoneDesc;
    /**
     * The phoneType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $phoneType;
    /**
     * Constructor method for WDDeviceInfoDetail
     * @uses WDDeviceInfoDetail::setDeviceName()
     * @uses WDDeviceInfoDetail::setLines()
     * @uses WDDeviceInfoDetail::setPhoneDesc()
     * @uses WDDeviceInfoDetail::setPhoneType()
     * @param string $deviceName
     * @param string[] $lines
     * @param string $phoneDesc
     * @param string $phoneType
     */
    public function __construct($deviceName = null, array $lines = array(), $phoneDesc = null, $phoneType = null)
    {
        $this
            ->setDeviceName($deviceName)
            ->setLines($lines)
            ->setPhoneDesc($phoneDesc)
            ->setPhoneType($phoneType);
    }
    /**
     * Get deviceName value
     * @return string|null
     */
    public function getDeviceName()
    {
        return $this->deviceName;
    }
    /**
     * Set deviceName value
     * @param string $deviceName
     * @return \StructType\WDDeviceInfoDetail
     */
    public function setDeviceName($deviceName = null)
    {
        // validation for constraint: string
        if (!is_null($deviceName) && !is_string($deviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceName)), __LINE__);
        }
        $this->deviceName = $deviceName;
        return $this;
    }
    /**
     * Get lines value
     * @return string[]|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @throws \InvalidArgumentException
     * @param string[] $lines
     * @return \StructType\WDDeviceInfoDetail
     */
    public function setLines(array $lines = array())
    {
        foreach ($lines as $wDDeviceInfoDetailLinesItem) {
            // validation for constraint: itemType
            if (!is_string($wDDeviceInfoDetailLinesItem)) {
                throw new \InvalidArgumentException(sprintf('The lines property can only contain items of string, "%s" given', is_object($wDDeviceInfoDetailLinesItem) ? get_class($wDDeviceInfoDetailLinesItem) : gettype($wDDeviceInfoDetailLinesItem)), __LINE__);
            }
        }
        $this->lines = $lines;
        return $this;
    }
    /**
     * Add item to lines value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\WDDeviceInfoDetail
     */
    public function addToLines($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The lines property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->lines[] = $item;
        return $this;
    }
    /**
     * Get phoneDesc value
     * @return string|null
     */
    public function getPhoneDesc()
    {
        return $this->phoneDesc;
    }
    /**
     * Set phoneDesc value
     * @param string $phoneDesc
     * @return \StructType\WDDeviceInfoDetail
     */
    public function setPhoneDesc($phoneDesc = null)
    {
        // validation for constraint: string
        if (!is_null($phoneDesc) && !is_string($phoneDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneDesc)), __LINE__);
        }
        $this->phoneDesc = $phoneDesc;
        return $this;
    }
    /**
     * Get phoneType value
     * @return string|null
     */
    public function getPhoneType()
    {
        return $this->phoneType;
    }
    /**
     * Set phoneType value
     * @param string $phoneType
     * @return \StructType\WDDeviceInfoDetail
     */
    public function setPhoneType($phoneType = null)
    {
        // validation for constraint: string
        if (!is_null($phoneType) && !is_string($phoneType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneType)), __LINE__);
        }
        $this->phoneType = $phoneType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WDDeviceInfoDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
