<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserProfile StructType
 * @subpackage Structs
 */
class UserProfile extends AbstractStructBase
{
    /**
     * The user
     * @var string
     */
    public $user;
    /**
     * The deviceName
     * @var string
     */
    public $deviceName;
    /**
     * The lineNumber
     * @var string
     */
    public $lineNumber;
    /**
     * The supportEM
     * @var bool
     */
    public $supportEM;
    /**
     * The locale
     * @var string
     */
    public $locale;
    /**
     * The dontAutoClose
     * @var bool
     */
    public $dontAutoClose;
    /**
     * The dontShowCallConf
     * @var bool
     */
    public $dontShowCallConf;
    /**
     * Constructor method for UserProfile
     * @uses UserProfile::setUser()
     * @uses UserProfile::setDeviceName()
     * @uses UserProfile::setLineNumber()
     * @uses UserProfile::setSupportEM()
     * @uses UserProfile::setLocale()
     * @uses UserProfile::setDontAutoClose()
     * @uses UserProfile::setDontShowCallConf()
     * @param string $user
     * @param string $deviceName
     * @param string $lineNumber
     * @param bool $supportEM
     * @param string $locale
     * @param bool $dontAutoClose
     * @param bool $dontShowCallConf
     */
    public function __construct($user = null, $deviceName = null, $lineNumber = null, $supportEM = null, $locale = null, $dontAutoClose = null, $dontShowCallConf = null)
    {
        $this
            ->setUser($user)
            ->setDeviceName($deviceName)
            ->setLineNumber($lineNumber)
            ->setSupportEM($supportEM)
            ->setLocale($locale)
            ->setDontAutoClose($dontAutoClose)
            ->setDontShowCallConf($dontShowCallConf);
    }
    /**
     * Get user value
     * @return string|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\UserProfile
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get deviceName value
     * @return string|null
     */
    public function getDeviceName()
    {
        return $this->deviceName;
    }
    /**
     * Set deviceName value
     * @param string $deviceName
     * @return \StructType\UserProfile
     */
    public function setDeviceName($deviceName = null)
    {
        // validation for constraint: string
        if (!is_null($deviceName) && !is_string($deviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceName)), __LINE__);
        }
        $this->deviceName = $deviceName;
        return $this;
    }
    /**
     * Get lineNumber value
     * @return string|null
     */
    public function getLineNumber()
    {
        return $this->lineNumber;
    }
    /**
     * Set lineNumber value
     * @param string $lineNumber
     * @return \StructType\UserProfile
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: string
        if (!is_null($lineNumber) && !is_string($lineNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineNumber)), __LINE__);
        }
        $this->lineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get supportEM value
     * @return bool|null
     */
    public function getSupportEM()
    {
        return $this->supportEM;
    }
    /**
     * Set supportEM value
     * @param bool $supportEM
     * @return \StructType\UserProfile
     */
    public function setSupportEM($supportEM = null)
    {
        // validation for constraint: boolean
        if (!is_null($supportEM) && !is_bool($supportEM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($supportEM)), __LINE__);
        }
        $this->supportEM = $supportEM;
        return $this;
    }
    /**
     * Get locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->locale;
    }
    /**
     * Set locale value
     * @param string $locale
     * @return \StructType\UserProfile
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: string
        if (!is_null($locale) && !is_string($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locale)), __LINE__);
        }
        $this->locale = $locale;
        return $this;
    }
    /**
     * Get dontAutoClose value
     * @return bool|null
     */
    public function getDontAutoClose()
    {
        return $this->dontAutoClose;
    }
    /**
     * Set dontAutoClose value
     * @param bool $dontAutoClose
     * @return \StructType\UserProfile
     */
    public function setDontAutoClose($dontAutoClose = null)
    {
        // validation for constraint: boolean
        if (!is_null($dontAutoClose) && !is_bool($dontAutoClose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($dontAutoClose)), __LINE__);
        }
        $this->dontAutoClose = $dontAutoClose;
        return $this;
    }
    /**
     * Get dontShowCallConf value
     * @return bool|null
     */
    public function getDontShowCallConf()
    {
        return $this->dontShowCallConf;
    }
    /**
     * Set dontShowCallConf value
     * @param bool $dontShowCallConf
     * @return \StructType\UserProfile
     */
    public function setDontShowCallConf($dontShowCallConf = null)
    {
        // validation for constraint: boolean
        if (!is_null($dontShowCallConf) && !is_bool($dontShowCallConf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($dontShowCallConf)), __LINE__);
        }
        $this->dontShowCallConf = $dontShowCallConf;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
