<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WDDeviceInfo StructType
 * @subpackage Structs
 */
class WDDeviceInfo extends AbstractStructBase
{
    /**
     * The deviceName
     * @var string
     */
    public $deviceName;
    /**
     * The lines
     * Meta informations extracted from the WSDL
     * - arrayType: soapenc:string[]
     * - ref: soapenc:arrayType
     * @var string[]
     */
    public $lines;
    /**
     * Constructor method for WDDeviceInfo
     * @uses WDDeviceInfo::setDeviceName()
     * @uses WDDeviceInfo::setLines()
     * @param string $deviceName
     * @param string[] $lines
     */
    public function __construct($deviceName = null, array $lines = array())
    {
        $this
            ->setDeviceName($deviceName)
            ->setLines($lines);
    }
    /**
     * Get deviceName value
     * @return string|null
     */
    public function getDeviceName()
    {
        return $this->deviceName;
    }
    /**
     * Set deviceName value
     * @param string $deviceName
     * @return \StructType\WDDeviceInfo
     */
    public function setDeviceName($deviceName = null)
    {
        // validation for constraint: string
        if (!is_null($deviceName) && !is_string($deviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceName)), __LINE__);
        }
        $this->deviceName = $deviceName;
        return $this;
    }
    /**
     * Get lines value
     * @return string[]|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @throws \InvalidArgumentException
     * @param string[] $lines
     * @return \StructType\WDDeviceInfo
     */
    public function setLines(array $lines = array())
    {
        foreach ($lines as $wDDeviceInfoLinesItem) {
            // validation for constraint: itemType
            if (!is_string($wDDeviceInfoLinesItem)) {
                throw new \InvalidArgumentException(sprintf('The lines property can only contain items of string, "%s" given', is_object($wDDeviceInfoLinesItem) ? get_class($wDDeviceInfoLinesItem) : gettype($wDDeviceInfoLinesItem)), __LINE__);
            }
        }
        $this->lines = $lines;
        return $this;
    }
    /**
     * Add item to lines value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\WDDeviceInfo
     */
    public function addToLines($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The lines property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->lines[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WDDeviceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
