<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConfigResponse StructType
 * @subpackage Structs
 */
class GetConfigResponse extends AbstractStructBase
{
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The deviceInfoList
     * Meta informations extracted from the WSDL
     * - arrayType: impl:WDDeviceInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\WDDeviceInfo[]
     */
    public $deviceInfoList;
    /**
     * The responseCode
     * @var int
     */
    public $responseCode;
    /**
     * Constructor method for GetConfigResponse
     * @uses GetConfigResponse::setDescription()
     * @uses GetConfigResponse::setDeviceInfoList()
     * @uses GetConfigResponse::setResponseCode()
     * @param string $description
     * @param \StructType\WDDeviceInfo[] $deviceInfoList
     * @param int $responseCode
     */
    public function __construct($description = null, array $deviceInfoList = array(), $responseCode = null)
    {
        $this
            ->setDescription($description)
            ->setDeviceInfoList($deviceInfoList)
            ->setResponseCode($responseCode);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\GetConfigResponse
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get deviceInfoList value
     * @return \StructType\WDDeviceInfo[]|null
     */
    public function getDeviceInfoList()
    {
        return $this->deviceInfoList;
    }
    /**
     * Set deviceInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\WDDeviceInfo[] $deviceInfoList
     * @return \StructType\GetConfigResponse
     */
    public function setDeviceInfoList(array $deviceInfoList = array())
    {
        foreach ($deviceInfoList as $getConfigResponseDeviceInfoListItem) {
            // validation for constraint: itemType
            if (!$getConfigResponseDeviceInfoListItem instanceof \StructType\WDDeviceInfo) {
                throw new \InvalidArgumentException(sprintf('The deviceInfoList property can only contain items of \StructType\WDDeviceInfo, "%s" given', is_object($getConfigResponseDeviceInfoListItem) ? get_class($getConfigResponseDeviceInfoListItem) : gettype($getConfigResponseDeviceInfoListItem)), __LINE__);
            }
        }
        $this->deviceInfoList = $deviceInfoList;
        return $this;
    }
    /**
     * Add item to deviceInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\WDDeviceInfo $item
     * @return \StructType\GetConfigResponse
     */
    public function addToDeviceInfoList(\StructType\WDDeviceInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WDDeviceInfo) {
            throw new \InvalidArgumentException(sprintf('The deviceInfoList property can only contain items of \StructType\WDDeviceInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->deviceInfoList[] = $item;
        return $this;
    }
    /**
     * Get responseCode value
     * @return int|null
     */
    public function getResponseCode()
    {
        return $this->responseCode;
    }
    /**
     * Set responseCode value
     * @param int $responseCode
     * @return \StructType\GetConfigResponse
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: int
        if (!is_null($responseCode) && !is_numeric($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($responseCode)), __LINE__);
        }
        $this->responseCode = $responseCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetConfigResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
