<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConfigResponseDetail StructType
 * @subpackage Structs
 */
class ConfigResponseDetail extends AbstractStructBase
{
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The deviceInfoListDetail
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - arrayType: impl:WDDeviceInfoDetail[]
     * - ref: soapenc:arrayType
     * @var \StructType\WDDeviceInfoDetail[]
     */
    public $deviceInfoListDetail;
    /**
     * The responseCode
     * @var int
     */
    public $responseCode;
    /**
     * Constructor method for ConfigResponseDetail
     * @uses ConfigResponseDetail::setDescription()
     * @uses ConfigResponseDetail::setDeviceInfoListDetail()
     * @uses ConfigResponseDetail::setResponseCode()
     * @param string $description
     * @param \StructType\WDDeviceInfoDetail[] $deviceInfoListDetail
     * @param int $responseCode
     */
    public function __construct($description = null, array $deviceInfoListDetail = array(), $responseCode = null)
    {
        $this
            ->setDescription($description)
            ->setDeviceInfoListDetail($deviceInfoListDetail)
            ->setResponseCode($responseCode);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ConfigResponseDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get deviceInfoListDetail value
     * @return \StructType\WDDeviceInfoDetail[]|null
     */
    public function getDeviceInfoListDetail()
    {
        return $this->deviceInfoListDetail;
    }
    /**
     * Set deviceInfoListDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\WDDeviceInfoDetail[] $deviceInfoListDetail
     * @return \StructType\ConfigResponseDetail
     */
    public function setDeviceInfoListDetail(array $deviceInfoListDetail = array())
    {
        foreach ($deviceInfoListDetail as $configResponseDetailDeviceInfoListDetailItem) {
            // validation for constraint: itemType
            if (!$configResponseDetailDeviceInfoListDetailItem instanceof \StructType\WDDeviceInfoDetail) {
                throw new \InvalidArgumentException(sprintf('The deviceInfoListDetail property can only contain items of \StructType\WDDeviceInfoDetail, "%s" given', is_object($configResponseDetailDeviceInfoListDetailItem) ? get_class($configResponseDetailDeviceInfoListDetailItem) : gettype($configResponseDetailDeviceInfoListDetailItem)), __LINE__);
            }
        }
        $this->deviceInfoListDetail = $deviceInfoListDetail;
        return $this;
    }
    /**
     * Add item to deviceInfoListDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\WDDeviceInfoDetail $item
     * @return \StructType\ConfigResponseDetail
     */
    public function addToDeviceInfoListDetail(\StructType\WDDeviceInfoDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WDDeviceInfoDetail) {
            throw new \InvalidArgumentException(sprintf('The deviceInfoListDetail property can only contain items of \StructType\WDDeviceInfoDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->deviceInfoListDetail[] = $item;
        return $this;
    }
    /**
     * Get responseCode value
     * @return int|null
     */
    public function getResponseCode()
    {
        return $this->responseCode;
    }
    /**
     * Set responseCode value
     * @param int $responseCode
     * @return \StructType\ConfigResponseDetail
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: int
        if (!is_null($responseCode) && !is_numeric($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($responseCode)), __LINE__);
        }
        $this->responseCode = $responseCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConfigResponseDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
