<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consulta ServiceType
 * @subpackage Services
 */
class Consulta extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConsultaMutuales
     * Meta informations extracted from the WSDL
     * - documentation: Method Name and Documentation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $ctaUsr
     * @param string $pswUsr
     * @param string $rUT
     * @param string $dV
     * @param string $fechaNac
     * @return struct|bool
     */
    public function ConsultaMutuales($ctaUsr, $pswUsr, $rUT, $dV, $fechaNac)
    {
        try {
            $this->setResult(self::getSoapClient()->ConsultaMutuales($ctaUsr, $pswUsr, $rUT, $dV, $fechaNac));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return struct
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
