<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMarka ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMarka
 * @subpackage Arrays
 */
class ArrayOfMarka extends AbstractStructArrayBase
{
    /**
     * The Marka
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Marka[]
     */
    public $Marka;
    /**
     * Constructor method for ArrayOfMarka
     * @uses ArrayOfMarka::setMarka()
     * @param \StructType\Marka[] $marka
     */
    public function __construct(array $marka = array())
    {
        $this
            ->setMarka($marka);
    }
    /**
     * Get Marka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Marka[]|null
     */
    public function getMarka()
    {
        return isset($this->Marka) ? $this->Marka : null;
    }
    /**
     * Set Marka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Marka[] $marka
     * @return \ArrayType\ArrayOfMarka
     */
    public function setMarka(array $marka = array())
    {
        foreach ($marka as $arrayOfMarkaMarkaItem) {
            // validation for constraint: itemType
            if (!$arrayOfMarkaMarkaItem instanceof \StructType\Marka) {
                throw new \InvalidArgumentException(sprintf('The Marka property can only contain items of \StructType\Marka, "%s" given', is_object($arrayOfMarkaMarkaItem) ? get_class($arrayOfMarkaMarkaItem) : gettype($arrayOfMarkaMarkaItem)), __LINE__);
            }
        }
        if (is_null($marka) || (is_array($marka) && empty($marka))) {
            unset($this->Marka);
        } else {
            $this->Marka = $marka;
        }
        return $this;
    }
    /**
     * Add item to Marka value
     * @throws \InvalidArgumentException
     * @param \StructType\Marka $item
     * @return \ArrayType\ArrayOfMarka
     */
    public function addToMarka(\StructType\Marka $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Marka) {
            throw new \InvalidArgumentException(sprintf('The Marka property can only contain items of \StructType\Marka, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Marka[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Marka|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Marka|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Marka|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Marka|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Marka|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Marka
     */
    public function getAttributeName()
    {
        return 'Marka';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMarka
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
