<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParaBirimi StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ParaBirimi
 * @subpackage Structs
 */
class ParaBirimi extends AbstractStructBase
{
    /**
     * The Aktif
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktif;
    /**
     * The DovizKodu
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DovizKodu;
    /**
     * The GuncellemeTarihi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GuncellemeTarihi;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Kur
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Kur;
    /**
     * The Tanim
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tanim;
    /**
     * Constructor method for ParaBirimi
     * @uses ParaBirimi::setAktif()
     * @uses ParaBirimi::setDovizKodu()
     * @uses ParaBirimi::setGuncellemeTarihi()
     * @uses ParaBirimi::setID()
     * @uses ParaBirimi::setKur()
     * @uses ParaBirimi::setTanim()
     * @param bool $aktif
     * @param string $dovizKodu
     * @param string $guncellemeTarihi
     * @param int $iD
     * @param float $kur
     * @param string $tanim
     */
    public function __construct($aktif = null, $dovizKodu = null, $guncellemeTarihi = null, $iD = null, $kur = null, $tanim = null)
    {
        $this
            ->setAktif($aktif)
            ->setDovizKodu($dovizKodu)
            ->setGuncellemeTarihi($guncellemeTarihi)
            ->setID($iD)
            ->setKur($kur)
            ->setTanim($tanim);
    }
    /**
     * Get Aktif value
     * @return bool|null
     */
    public function getAktif()
    {
        return $this->Aktif;
    }
    /**
     * Set Aktif value
     * @param bool $aktif
     * @return \StructType\ParaBirimi
     */
    public function setAktif($aktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktif) && !is_bool($aktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($aktif)), __LINE__);
        }
        $this->Aktif = $aktif;
        return $this;
    }
    /**
     * Get DovizKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDovizKodu()
    {
        return isset($this->DovizKodu) ? $this->DovizKodu : null;
    }
    /**
     * Set DovizKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dovizKodu
     * @return \StructType\ParaBirimi
     */
    public function setDovizKodu($dovizKodu = null)
    {
        // validation for constraint: string
        if (!is_null($dovizKodu) && !is_string($dovizKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dovizKodu)), __LINE__);
        }
        if (is_null($dovizKodu) || (is_array($dovizKodu) && empty($dovizKodu))) {
            unset($this->DovizKodu);
        } else {
            $this->DovizKodu = $dovizKodu;
        }
        return $this;
    }
    /**
     * Get GuncellemeTarihi value
     * @return string|null
     */
    public function getGuncellemeTarihi()
    {
        return $this->GuncellemeTarihi;
    }
    /**
     * Set GuncellemeTarihi value
     * @param string $guncellemeTarihi
     * @return \StructType\ParaBirimi
     */
    public function setGuncellemeTarihi($guncellemeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($guncellemeTarihi) && !is_string($guncellemeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guncellemeTarihi)), __LINE__);
        }
        $this->GuncellemeTarihi = $guncellemeTarihi;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\ParaBirimi
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Kur value
     * @return float|null
     */
    public function getKur()
    {
        return $this->Kur;
    }
    /**
     * Set Kur value
     * @param float $kur
     * @return \StructType\ParaBirimi
     */
    public function setKur($kur = null)
    {
        $this->Kur = $kur;
        return $this;
    }
    /**
     * Get Tanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTanim()
    {
        return isset($this->Tanim) ? $this->Tanim : null;
    }
    /**
     * Set Tanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tanim
     * @return \StructType\ParaBirimi
     */
    public function setTanim($tanim = null)
    {
        // validation for constraint: string
        if (!is_null($tanim) && !is_string($tanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tanim)), __LINE__);
        }
        if (is_null($tanim) || (is_array($tanim) && empty($tanim))) {
            unset($this->Tanim);
        } else {
            $this->Tanim = $tanim;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ParaBirimi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
