<?php

namespace Liberty\Services\Inspeccion\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consultar ServiceType
 * @subpackage Services
 */
class Consultar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named consultar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Liberty\Services\Inspeccion\StructType\Consultar $parameters
     * @return \Liberty\Services\Inspeccion\StructType\ConsultarResponse|bool
     */
    public function consultar(\Liberty\Services\Inspeccion\StructType\Consultar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->consultar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Liberty\Services\Inspeccion\StructType\ConsultarResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
