<?php

namespace Liberty\Services\Inspeccion\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Solicitar ServiceType
 * @subpackage Services
 */
class Solicitar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named solicitarAlt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Liberty\Services\Inspeccion\StructType\SolicitarAlt $parameters
     * @return \Liberty\Services\Inspeccion\StructType\SolicitarAltResponse|bool
     */
    public function solicitarAlt(\Liberty\Services\Inspeccion\StructType\SolicitarAlt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->solicitarAlt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Liberty\Services\Inspeccion\StructType\SolicitarAltResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
